/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.Artifact;
import com.google.gwt.core.ext.linker.ArtifactSet;
import com.google.gwt.core.ext.linker.EmittedArtifact;
import com.google.gwt.core.ext.linker.SelectionProperty;
import com.google.gwt.core.ext.linker.impl.BinaryOnlyArtifactWrapper;
import com.google.gwt.core.ext.linker.impl.JarEntryEmittedArtifact;
import com.google.gwt.core.ext.linker.impl.StandardCompilationResult;
import com.google.gwt.core.ext.linker.impl.StandardLinkerContext;
import com.google.gwt.core.ext.linker.impl.StandardSelectionProperty;
import com.google.gwt.dev.AnalyzeModule;
import com.google.gwt.dev.CompileArgProcessor;
import com.google.gwt.dev.CompilePerms;
import com.google.gwt.dev.CompileTaskOptions;
import com.google.gwt.dev.CompileTaskOptionsImpl;
import com.google.gwt.dev.CompileTaskRunner;
import com.google.gwt.dev.CompilerContext;
import com.google.gwt.dev.Permutation;
import com.google.gwt.dev.Precompilation;
import com.google.gwt.dev.PrecompilationResult;
import com.google.gwt.dev.PrecompileTaskOptions;
import com.google.gwt.dev.PrecompileTaskOptionsImpl;
import com.google.gwt.dev.SourceSaver;
import com.google.gwt.dev.cfg.BindingProperties;
import com.google.gwt.dev.cfg.BindingProperty;
import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.dev.cfg.ModuleDefLoader;
import com.google.gwt.dev.cfg.PropertyCombinations;
import com.google.gwt.dev.cfg.ResourceLoader;
import com.google.gwt.dev.cfg.ResourceLoaders;
import com.google.gwt.dev.jjs.PermutationResult;
import com.google.gwt.dev.jjs.impl.codesplitter.CodeSplitter;
import com.google.gwt.dev.resource.ResourceOracle;
import com.google.gwt.dev.util.NullOutputFileSet;
import com.google.gwt.dev.util.OutputFileSet;
import com.google.gwt.dev.util.OutputFileSetOnDirectory;
import com.google.gwt.dev.util.OutputFileSetOnJar;
import com.google.gwt.dev.util.PersistenceBackedObject;
import com.google.gwt.dev.util.Util;
import com.google.gwt.dev.util.arg.ArgHandlerDeployDir;
import com.google.gwt.dev.util.arg.ArgHandlerExtraDir;
import com.google.gwt.dev.util.arg.ArgHandlerSaveSourceOutput;
import com.google.gwt.dev.util.arg.ArgHandlerWarDir;
import com.google.gwt.dev.util.arg.OptionDeployDir;
import com.google.gwt.dev.util.arg.OptionExtraDir;
import com.google.gwt.dev.util.arg.OptionSaveSourceOutput;
import com.google.gwt.dev.util.arg.OptionWarDir;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class Link {
    private final LinkOptionsImpl options;
    private final CompilerContext.Builder compilerContextBuilder = new CompilerContext.Builder();
    private CompilerContext compilerContext;

    public static void link(TreeLogger logger, ModuleDef module, ResourceOracle publicResourceOracle, ArtifactSet generatedArtifacts, Permutation[] permutations, List<PersistenceBackedObject<PermutationResult>> resultFiles, Set<PermutationResult> libraries, PrecompileTaskOptions precompileOptions, LinkOptions linkOptions) throws UnableToCompleteException, IOException {
        StandardLinkerContext linkerContext = new StandardLinkerContext(logger, module, publicResourceOracle, precompileOptions.getOutput());
        ArtifactSet artifacts = Link.doSimulatedShardingLink(logger, module, linkerContext, generatedArtifacts, permutations, resultFiles);
        Link.doProduceOutput(logger, artifacts, linkerContext, module, precompileOptions.shouldSaveSource(), linkOptions);
    }

    public static void linkOnePermutationToJar(TreeLogger logger, ModuleDef module, ResourceOracle publicResourceOracle, ArtifactSet generatedArtifacts, PermutationResult permResult, File jarFile, PrecompileTaskOptions precompileOptions) throws UnableToCompleteException {
        try {
            ZipEntry ze;
            String jarEntryPath;
            boolean success;
            if (jarFile.exists() && !(success = jarFile.delete())) {
                logger.log(TreeLogger.ERROR, "Linker output file " + jarFile.getName() + " already exists and can't be deleted.");
            }
            JarOutputStream jar = new JarOutputStream(new FileOutputStream(jarFile));
            StandardLinkerContext linkerContext = new StandardLinkerContext(logger, module, publicResourceOracle, precompileOptions.getOutput());
            StandardCompilationResult compilation = new StandardCompilationResult(permResult);
            Link.addSelectionPermutations(compilation, permResult.getPermutation(), linkerContext);
            ArtifactSet permArtifacts = new ArtifactSet(generatedArtifacts);
            permArtifacts.addAll(permResult.getArtifacts());
            permArtifacts.add(compilation);
            ArtifactSet linkedArtifacts = linkerContext.invokeLinkForOnePermutation(logger, compilation, permArtifacts);
            for (EmittedArtifact art : linkedArtifacts.find(EmittedArtifact.class)) {
                EmittedArtifact.Visibility visibility = art.getVisibility();
                jarEntryPath = visibility.name() + "/";
                jarEntryPath = visibility == EmittedArtifact.Visibility.Public ? jarEntryPath + art.getPartialPath() : jarEntryPath + Link.prefixArtifactPath(art, linkerContext);
                ze = new ZipEntry(jarEntryPath);
                ze.setTime(OutputFileSetOnJar.normalizeTimestamps ? 0L : art.getLastModified());
                jar.putNextEntry(ze);
                art.writeTo(logger, jar);
                jar.closeEntry();
            }
            int numSerializedArtifacts = 0;
            for (Artifact<?> art : linkedArtifacts) {
                if (!art.isTransferableFromShards() || art instanceof EmittedArtifact) continue;
                jarEntryPath = "arts/" + numSerializedArtifacts++;
                ze = new ZipEntry(jarEntryPath);
                if (OutputFileSetOnJar.normalizeTimestamps) {
                    ze.setTime(0L);
                }
                jar.putNextEntry(ze);
                Util.writeObjectToStream(jar, art);
                jar.closeEntry();
            }
            jar.close();
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "Error linking", e);
            throw new UnableToCompleteException();
        }
    }

    public static void main(String[] args) {
        CompileTaskRunner.CompileTask task;
        boolean success = false;
        SpeedTracerLogger.Event linkEvent = SpeedTracerLogger.start(CompilerEventType.LINK, new String[0]);
        final LinkOptionsImpl options = new LinkOptionsImpl();
        if (new ArgProcessor(options).processArgs(args) && CompileTaskRunner.runWithAppropriateLogger(options, task = new CompileTaskRunner.CompileTask(){

            @Override
            public boolean run(TreeLogger logger) throws UnableToCompleteException {
                return new Link(options).run(logger);
            }
        })) {
            success = true;
        }
        linkEvent.end(new String[0]);
        System.exit(success ? 0 : 1);
    }

    public static ArtifactSet simulateTransferThinning(ArtifactSet artifacts, StandardLinkerContext context) {
        ArtifactSet thinnedArtifacts = new ArtifactSet();
        for (Artifact<?> artifact : artifacts) {
            if (artifact instanceof EmittedArtifact) {
                EmittedArtifact emittedArtifact = (EmittedArtifact)artifact;
                String path = Link.getFullArtifactPath(emittedArtifact, context);
                thinnedArtifacts.add(new BinaryOnlyArtifactWrapper(path, emittedArtifact));
                continue;
            }
            if (!artifact.isTransferableFromShards()) continue;
            thinnedArtifacts.add(artifact);
        }
        return thinnedArtifacts;
    }

    private static void addSelectionPermutations(StandardCompilationResult compilation, Permutation permutation, StandardLinkerContext linkerContext) {
        for (BindingProperties properties : permutation.getProperties().getSoftProperties()) {
            compilation.addSelectionPermutation(Link.computeSelectionPermutation(linkerContext, properties));
            compilation.addSoftPermutation(Link.computeSoftPermutation(linkerContext, properties));
        }
    }

    static OutputFileSet chooseOutputFileSet(File dirOrJar, String pathPrefix) throws IOException {
        if (dirOrJar == null) {
            return new NullOutputFileSet();
        }
        String name = dirOrJar.getName();
        if (!dirOrJar.isDirectory() && (name.endsWith(".war") || name.endsWith(".jar") || name.endsWith(".zip"))) {
            return new OutputFileSetOnJar(dirOrJar, pathPrefix);
        }
        Util.recursiveDelete(new File(dirOrJar, pathPrefix), true);
        return new OutputFileSetOnDirectory(dirOrJar, pathPrefix);
    }

    private static Map<SelectionProperty, String> computeSelectionPermutation(StandardLinkerContext linkerContext, BindingProperties properties) {
        BindingProperty[] orderedProps = properties.getOrderedProps();
        String[] orderedPropValues = properties.getOrderedPropValues();
        HashMap<SelectionProperty, String> unboundProperties = new HashMap<SelectionProperty, String>();
        for (int i = 0; i < orderedProps.length; ++i) {
            StandardSelectionProperty key = linkerContext.getProperty(orderedProps[i].getName());
            if (key.tryGetValue() != null || key.isDerived()) continue;
            unboundProperties.put(key, orderedPropValues[i]);
        }
        return unboundProperties;
    }

    private static Map<SelectionProperty, String> computeSoftPermutation(StandardLinkerContext linkerContext, BindingProperties properties) {
        BindingProperty[] orderedProps = properties.getOrderedProps();
        String[] orderedPropValues = properties.getOrderedPropValues();
        HashMap<SelectionProperty, String> softProperties = new HashMap<SelectionProperty, String>();
        for (int i = 0; i < orderedProps.length; ++i) {
            if (orderedProps[i].getCollapsedValuesSets().isEmpty()) continue;
            StandardSelectionProperty key = linkerContext.getProperty(orderedProps[i].getName());
            softProperties.put(key, orderedPropValues[i]);
        }
        return softProperties;
    }

    private static void doProduceOutput(TreeLogger logger, ArtifactSet artifacts, StandardLinkerContext linkerContext, ModuleDef module, boolean saveSources, LinkOptions options) throws IOException, UnableToCompleteException {
        String destPrefix = module.getName() + "/";
        OutputFileSet outFileSet = Link.chooseOutputFileSet(options.getWarDir(), destPrefix);
        OutputFileSet extraFileSet = Link.chooseOutputFileSet(options.getExtraDir(), destPrefix);
        OutputFileSet deployFileSet = options.getDeployDir().equals(options.getExtraDir()) ? extraFileSet : Link.chooseOutputFileSet(options.getDeployDir(), destPrefix);
        linkerContext.produceOutput(logger, artifacts, EmittedArtifact.Visibility.Public, outFileSet);
        linkerContext.produceOutput(logger, artifacts, EmittedArtifact.Visibility.Deploy, deployFileSet);
        linkerContext.produceOutput(logger, artifacts, EmittedArtifact.Visibility.Private, extraFileSet);
        boolean embedSourcesContent = linkerContext.getModule().shouldEmbedSourceMapContents();
        if (saveSources && !embedSourcesContent) {
            ResourceLoader loader = ResourceLoaders.fromContextClassLoader();
            SourceSaver.save(logger, artifacts, loader, options, destPrefix, extraFileSet);
        }
        outFileSet.close();
        extraFileSet.close();
        if (deployFileSet != extraFileSet) {
            deployFileSet.close();
        }
        logger.log(TreeLogger.INFO, "Link succeeded");
    }

    private static ArtifactSet doSimulatedShardingLink(TreeLogger logger, ModuleDef module, StandardLinkerContext linkerContext, ArtifactSet generatedArtifacts, Permutation[] perms, List<PersistenceBackedObject<PermutationResult>> resultFiles) throws UnableToCompleteException {
        ArtifactSet combinedArtifacts = new ArtifactSet();
        for (int i = 0; i < perms.length; ++i) {
            ArtifactSet newArtifacts = Link.finishPermutation(logger, perms[i], resultFiles.get(i), linkerContext, generatedArtifacts);
            combinedArtifacts.addAll(newArtifacts);
        }
        combinedArtifacts.addAll(linkerContext.getArtifactsForPublicResources(logger, module));
        ArtifactSet legacyLinkedArtifacts = linkerContext.invokeLegacyLinkers(logger, combinedArtifacts);
        ArtifactSet thinnedArtifacts = Link.simulateTransferThinning(legacyLinkedArtifacts, linkerContext);
        return linkerContext.invokeFinalLink(logger, thinnedArtifacts);
    }

    private static ArtifactSet finishPermutation(TreeLogger logger, Permutation perm, PersistenceBackedObject<PermutationResult> resultFile, StandardLinkerContext linkerContext, ArtifactSet generatedArtifacts) throws UnableToCompleteException {
        PermutationResult permResult = resultFile.newInstance(logger);
        StandardCompilationResult compilation = new StandardCompilationResult(permResult);
        Link.addSelectionPermutations(compilation, perm, linkerContext);
        Link.logScriptSize(logger, perm.getId(), compilation);
        ArtifactSet permArtifacts = new ArtifactSet(generatedArtifacts);
        permArtifacts.addAll(permResult.getArtifacts());
        permArtifacts.add(compilation);
        permArtifacts.freeze();
        return linkerContext.invokeLinkForOnePermutation(logger, compilation, permArtifacts);
    }

    private static String getFullArtifactPath(EmittedArtifact emittedArtifact, StandardLinkerContext context) {
        String path = emittedArtifact.getPartialPath();
        if (emittedArtifact.getVisibility() != EmittedArtifact.Visibility.Public) {
            path = Link.prefixArtifactPath(emittedArtifact, context);
        }
        return path;
    }

    private static void logScriptSize(TreeLogger logger, int permId, StandardCompilationResult compilation) {
        if (!logger.isLoggable(TreeLogger.TRACE)) {
            return;
        }
        String[] javaScript = compilation.getJavaScript();
        int[] jsLengths = new int[javaScript.length];
        for (int i = 0; i < javaScript.length; ++i) {
            jsLengths[i] = javaScript[i].length();
        }
        int totalSize = CodeSplitter.computeTotalSize(jsLengths);
        if (logger.isLoggable(TreeLogger.TRACE)) {
            logger.log(TreeLogger.TRACE, "Permutation " + permId + " (strong name " + compilation.getStrongName() + ") has an initial download size of " + javaScript[0].length() + " and total script size of " + totalSize);
        }
    }

    private static String prefixArtifactPath(EmittedArtifact art, StandardLinkerContext linkerContext) {
        String pathWithLinkerName = linkerContext.getExtraPathForLinker(art.getLinker(), art.getPartialPath());
        if (pathWithLinkerName.startsWith("/")) {
            pathWithLinkerName = pathWithLinkerName.substring(1);
        }
        return pathWithLinkerName;
    }

    private static ArtifactSet scanCompilePermResults(TreeLogger logger, List<File> resultFiles) throws IOException, UnableToCompleteException {
        ArtifactSet artifacts = new ArtifactSet();
        for (File resultFile : resultFiles) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(resultFile);
            }
            catch (ZipException ze) {
                logger.log(TreeLogger.ERROR, "Error opening " + resultFile + " as jar file.", ze);
                throw new UnableToCompleteException();
            }
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                Artifact artForEntry;
                block11: {
                    JarEntry entry = entries.nextElement();
                    if (entry.isDirectory()) continue;
                    artForEntry = null;
                    String entryName = entry.getName();
                    if (entryName.startsWith("arts/")) {
                        try {
                            artForEntry = Util.readStreamAsObject(new BufferedInputStream(jarFile.getInputStream(entry)), Artifact.class);
                            assert (artForEntry.isTransferableFromShards());
                            break block11;
                        }
                        catch (ClassNotFoundException e) {
                            logger.log(TreeLogger.ERROR, "Failed trying to deserialize an artifact", e);
                            throw new UnableToCompleteException();
                        }
                    }
                    int slash = entryName.indexOf(47);
                    if (slash >= 0) {
                        try {
                            EmittedArtifact.Visibility visibility = EmittedArtifact.Visibility.valueOf(entryName.substring(0, slash));
                            String path = entryName.substring(slash + 1);
                            JarEntryEmittedArtifact jarArtifact = new JarEntryEmittedArtifact(path, resultFile, entry);
                            jarArtifact.setVisibility(visibility);
                            artForEntry = jarArtifact;
                        }
                        catch (IllegalArgumentException e) {
                            continue;
                        }
                    }
                }
                artifacts.add(artForEntry);
            }
            jarFile.close();
        }
        return artifacts;
    }

    public Link(LinkOptions options) {
        this.options = new LinkOptionsImpl(options);
        this.compilerContext = this.compilerContextBuilder.options(new PrecompileTaskOptionsImpl(options)).build();
    }

    public boolean run(TreeLogger logger) throws UnableToCompleteException {
        for (String moduleName : this.options.getModuleNames()) {
            ModuleDef module = ModuleDefLoader.loadFromClassPath(logger, moduleName);
            this.compilerContext = this.compilerContextBuilder.module(module).build();
            ResourceOracle publicResourceOracle = this.compilerContext.getPublicResourceOracle();
            File compilerWorkDir = this.options.getCompilerWorkDir(moduleName);
            PrecompileTaskOptions precompileOptions = AnalyzeModule.readAnalyzeModuleOptionsFile(logger, compilerWorkDir);
            PrecompilationResult precompileResults = null;
            if (precompileOptions == null) {
                File precompilationFile = new File(compilerWorkDir, "precompilation.ser");
                precompileResults = CompilePerms.readPrecompilationFile(logger, precompilationFile);
                if (precompileResults == null) {
                    return false;
                }
                if (precompileResults instanceof PrecompileTaskOptions) {
                    precompileOptions = (PrecompileTaskOptions)precompileResults;
                }
            }
            if (precompileOptions != null) {
                if (this.doLinkFinal(logger, compilerWorkDir, module, publicResourceOracle, precompileOptions)) continue;
                return false;
            }
            Precompilation precomp = (Precompilation)precompileResults;
            Permutation[] perms = precomp.getPermutations();
            List<PersistenceBackedObject<PermutationResult>> resultFiles = CompilePerms.makeResultFiles(compilerWorkDir, perms, this.compilerContext.getOptions());
            for (PersistenceBackedObject<PermutationResult> file : resultFiles) {
                if (file.exists()) continue;
                logger.log(TreeLogger.ERROR, "File not found '" + file.getPath() + "'; please compile all permutations");
                return false;
            }
            TreeLogger branch = logger.branch(TreeLogger.INFO, "Linking module " + module.getName());
            try {
                Link.link(branch, module, publicResourceOracle, precomp.getGeneratedArtifacts(), perms, resultFiles, Sets.newHashSet(), precomp.getUnifiedAst().getOptions(), this.options);
            }
            catch (IOException e) {
                logger.log(TreeLogger.ERROR, "Unexpected exception while producing output", e);
                throw new UnableToCompleteException();
            }
        }
        return true;
    }

    private boolean doLinkFinal(TreeLogger logger, File compilerWorkDir, ModuleDef module, ResourceOracle publicResourceOracle, PrecompileTaskOptions precompileOptions) throws UnableToCompleteException {
        int numPermutations = new PropertyCombinations(module.getProperties(), module.getActiveLinkerNames()).collapseProperties().size();
        ArrayList<File> resultFiles = new ArrayList<File>(numPermutations);
        for (int i = 0; i < numPermutations; ++i) {
            File f = CompilePerms.makePermFilename(compilerWorkDir, i);
            if (!f.exists()) {
                logger.log(TreeLogger.ERROR, "File not found '" + f.getAbsolutePath() + "'; please compile all permutations");
                return false;
            }
            resultFiles.add(f);
        }
        TreeLogger branch = logger.branch(TreeLogger.INFO, "Linking module " + module.getName());
        StandardLinkerContext linkerContext = new StandardLinkerContext(branch, module, publicResourceOracle, precompileOptions.getOutput());
        try {
            ArtifactSet artifacts = Link.scanCompilePermResults(logger, resultFiles);
            artifacts.addAll(linkerContext.getArtifactsForPublicResources(logger, module));
            artifacts = linkerContext.invokeFinalLink(logger, artifacts);
            Link.doProduceOutput(logger, artifacts, linkerContext, module, precompileOptions.shouldSaveSource(), this.options);
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "Exception during final linking", e);
            throw new UnableToCompleteException();
        }
        return true;
    }

    static class LinkOptionsImpl
    extends CompileTaskOptionsImpl
    implements LinkOptions {
        private File deployDir;
        private File extraDir;
        private File warDir;
        private File debugSourceDir;

        public LinkOptionsImpl() {
        }

        public LinkOptionsImpl(LinkOptions other) {
            this.copyFrom(other);
        }

        public void copyFrom(LinkOptions other) {
            super.copyFrom(other);
            this.setDeployDir(other.getDeployDir());
            this.setExtraDir(other.getExtraDir());
            this.setSaveSourceOutput(other.getSaveSourceOutput());
            this.setWarDir(other.getWarDir());
        }

        @Override
        public File getSaveSourceOutput() {
            return this.debugSourceDir;
        }

        @Override
        public File getDeployDir() {
            return this.deployDir == null ? new File(this.warDir, "WEB-INF/deploy") : this.deployDir;
        }

        @Override
        public File getExtraDir() {
            return this.extraDir;
        }

        @Override
        public File getWarDir() {
            return this.warDir;
        }

        @Override
        public void setSaveSourceOutput(File dest) {
            this.debugSourceDir = dest;
        }

        @Override
        public void setDeployDir(File dir) {
            this.deployDir = dir;
        }

        @Override
        public void setExtraDir(File extraDir) {
            this.extraDir = extraDir;
        }

        @Override
        public void setWarDir(File warDir) {
            this.warDir = warDir;
        }
    }

    static class ArgProcessor
    extends CompileArgProcessor {
        public ArgProcessor(LinkOptions options) {
            super(options);
            this.registerHandler(new ArgHandlerExtraDir(options));
            this.registerHandler(new ArgHandlerWarDir(options));
            this.registerHandler(new ArgHandlerDeployDir(options));
            this.registerHandler(new ArgHandlerSaveSourceOutput(options));
        }

        @Override
        protected String getName() {
            return Link.class.getName();
        }
    }

    public static interface LinkOptions
    extends OptionExtraDir,
    OptionWarDir,
    OptionDeployDir,
    OptionSaveSourceOutput,
    CompileTaskOptions {
    }
}

