/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import java.util.Arrays;

public final class GwtVersion
implements Comparable<GwtVersion> {
    private static final int NO_NAG = 999;
    private static final String DEFAULT_NO_NAG_VERSION = "0.0.999";
    private static final int COMPONENT_COUNT = 3;
    private final int[] components = new int[3];
    private final String suffix;

    public GwtVersion() {
        this(DEFAULT_NO_NAG_VERSION);
    }

    public GwtVersion(String versionString) throws NumberFormatException {
        this.suffix = this.parse(versionString);
    }

    @Override
    public int compareTo(GwtVersion other) {
        for (int i = 0; i < 3; ++i) {
            int c = this.components[i] - other.components[i];
            if (c == 0) continue;
            return c;
        }
        return this.compareSuffixes(this.suffix, other.suffix);
    }

    public boolean equals(Object o) {
        if (!(o instanceof GwtVersion)) {
            return false;
        }
        GwtVersion other = (GwtVersion)o;
        if (!Arrays.equals(this.components, other.components)) {
            return false;
        }
        return this.compareSuffixes(this.suffix, other.suffix) == 0;
    }

    public int[] getComponents() {
        int[] returnVal = new int[3];
        System.arraycopy(this.components, 0, returnVal, 0, 3);
        return returnVal;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public int hashCode() {
        return Arrays.hashCode(this.components) * 2 + (this.suffix == null ? 0 : 1);
    }

    public boolean isNoNagVersion() {
        return this.components[2] == 999;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String prefix = "";
        for (int i = 0; i < 3; ++i) {
            buf.append(prefix).append(this.components[i]);
            prefix = ".";
        }
        if (this.suffix != null) {
            buf.append(this.suffix);
        }
        return buf.toString();
    }

    private int compareSuffixes(String suffix1, String suffix2) {
        if (suffix1 == null) {
            return suffix2 == null ? 0 : 1;
        }
        if (suffix2 == null) {
            return -1;
        }
        return 0;
    }

    private String parse(String versionString) {
        int index;
        this.components[2] = 0;
        this.components[1] = 0;
        this.components[0] = 0;
        int len = versionString == null ? 0 : versionString.length();
        for (index = 0; index < len && !Character.isDigit(versionString.charAt(index)); ++index) {
        }
        for (int component = 0; component < 3; ++component) {
            int componentStart = index;
            while (index < len && Character.isDigit(versionString.charAt(index))) {
                ++index;
            }
            if (index > componentStart) {
                this.components[component] = Integer.parseInt(versionString.substring(componentStart, index));
            }
            if (index >= len || versionString.charAt(index) != '.') break;
            ++index;
        }
        return index < len ? versionString.substring(index) : null;
    }
}

