/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.CompilePermsServer;
import com.google.gwt.dev.CompilerContext;
import com.google.gwt.dev.Permutation;
import com.google.gwt.dev.PermutationWorker;
import com.google.gwt.dev.PermutationWorkerFactory;
import com.google.gwt.dev.TransientWorkerException;
import com.google.gwt.dev.jjs.PermutationResult;
import com.google.gwt.dev.jjs.UnifiedAst;
import com.google.gwt.dev.util.PersistenceBackedObject;
import com.google.gwt.dev.util.StringInterningObjectInputStream;
import com.google.gwt.dev.util.Util;
import com.google.gwt.util.tools.shared.StringUtils;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.management.ManagementFactory;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;

public class ExternalPermutationWorkerFactory
extends PermutationWorkerFactory {
    public static final String JAVA_COMMAND_PROPERTY = "gwt.jjs.javaCommand";
    public static final String JVM_ARGS_PROPERTY = "gwt.jjs.javaArgs";
    private static Random random = new Random();
    private ServerSocket sock = null;

    private static String launchExternalWorker(TreeLogger logger, int port) throws UnableToCompleteException {
        String javaCommand = System.getProperty(JAVA_COMMAND_PROPERTY, System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
        if (logger.isLoggable(TreeLogger.TRACE)) {
            logger.log(TreeLogger.TRACE, "javaCommand = " + javaCommand);
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(javaCommand);
        String userJvmArgs = System.getProperty(JVM_ARGS_PROPERTY);
        if (userJvmArgs == null) {
            args.addAll(ManagementFactory.getRuntimeMXBean().getInputArguments());
        } else {
            args.addAll(Arrays.asList(userJvmArgs.split(" ")));
        }
        TreeLogger.Type logLevel = TreeLogger.ERROR;
        for (TreeLogger.Type t : TreeLogger.Type.values()) {
            if (!logger.isLoggable(t)) break;
            logLevel = t;
        }
        byte[] cookieBytes = new byte[16];
        random.nextBytes(cookieBytes);
        String cookie = StringUtils.toHexString(cookieBytes);
        args.addAll(Arrays.asList(CompilePermsServer.class.getName(), "-host", "localhost", "-port", String.valueOf(port), "-logLevel", logLevel.toString(), "-cookie", cookie));
        Iterator iter = args.iterator();
        while (iter.hasNext()) {
            String arg = (String)iter.next();
            if (!arg.startsWith("-agentlib")) continue;
            iter.remove();
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.environment().put("CLASSPATH", ManagementFactory.getRuntimeMXBean().getClassPath());
        builder.command(args);
        try {
            final Process proc = builder.start();
            final BufferedReader bin = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            final BufferedReader berr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            final TreeLogger procLogger = logger.branch(TreeLogger.DEBUG, "Process output");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            String line;
                            while ((line = bin.readLine()) != null) {
                                procLogger.log(TreeLogger.INFO, line);
                            }
                        }
                        catch (EOFException line) {
                            continue;
                        }
                        catch (IOException e) {
                            procLogger.log(TreeLogger.ERROR, "Unable to read from subprocess", e);
                            continue;
                        }
                        break;
                    }
                }
            }).start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            String line;
                            while ((line = berr.readLine()) != null) {
                                procLogger.log(TreeLogger.ERROR, line);
                            }
                        }
                        catch (EOFException line) {
                            continue;
                        }
                        catch (IOException e) {
                            procLogger.log(TreeLogger.ERROR, "Unable to read from subprocess", e);
                            continue;
                        }
                        break;
                    }
                }
            }).start();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        proc.exitValue();
                    }
                    catch (IllegalThreadStateException e) {
                        proc.destroy();
                    }
                }
            }));
            return cookie;
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "Unable to start external process", e);
            throw new UnableToCompleteException();
        }
    }

    @Override
    public Collection<PermutationWorker> getWorkers(TreeLogger logger, UnifiedAst unifiedAst, int numWorkers) throws UnableToCompleteException {
        File astFile;
        this.ensureSocket(logger);
        try {
            astFile = File.createTempFile("externalPermutationWorkerFactory", ".ser");
            astFile.deleteOnExit();
            Util.writeObjectAsFile(logger, astFile, unifiedAst);
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "Unable to create temporary file", e);
            throw new UnableToCompleteException();
        }
        Set<String> cookies = Collections.synchronizedSet(new HashSet(numWorkers));
        CountedServerSocket countedSock = new CountedServerSocket(this.sock, numWorkers);
        ArrayList<PermutationWorker> toReturn = new ArrayList<PermutationWorker>(numWorkers);
        for (int i = 0; i < numWorkers; ++i) {
            String cookie = ExternalPermutationWorkerFactory.launchExternalWorker(logger, this.sock.getLocalPort());
            cookies.add(cookie);
            toReturn.add(new ExternalPermutationWorker(countedSock, astFile, cookies));
        }
        return toReturn;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    private synchronized void ensureSocket(TreeLogger logger) throws UnableToCompleteException {
        if (this.sock != null) {
            return;
        }
        try {
            this.sock = new ServerSocket();
            this.sock.setSoTimeout(60000);
            this.sock.bind(null);
            if (logger.isLoggable(TreeLogger.SPAM)) {
                logger.log(TreeLogger.SPAM, "Listening for external workers on port " + this.sock.getLocalPort());
            }
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "Unable to create socket", e);
            throw new UnableToCompleteException();
        }
    }

    private static class ExternalPermutationWorker
    implements PermutationWorker {
        private final File astFile;
        private final Set<String> cookies;
        private ObjectInputStream in;
        private ObjectOutputStream out;
        private final CountedServerSocket serverSocket;
        private Socket workerSocket;

        public ExternalPermutationWorker(CountedServerSocket sock, File astFile, Set<String> cookies) {
            this.astFile = astFile;
            this.cookies = cookies;
            this.serverSocket = sock;
        }

        @Override
        public void compile(TreeLogger logger, CompilerContext compilerContext, Permutation permutation, PersistenceBackedObject<PermutationResult> resultFile) throws TransientWorkerException, UnableToCompleteException {
            if (this.workerSocket == null) {
                try {
                    this.workerSocket = this.serverSocket.accept();
                    this.in = new StringInterningObjectInputStream(this.workerSocket.getInputStream());
                    this.out = new ObjectOutputStream(this.workerSocket.getOutputStream());
                    String c = this.in.readUTF();
                    if (!this.cookies.contains(c)) {
                        throw new TransientWorkerException("Received unknown cookie " + c, null);
                    }
                    this.out.writeObject(this.astFile);
                    long memoryUse = this.in.readLong();
                    if (logger.isLoggable(TreeLogger.SPAM)) {
                        logger.log(TreeLogger.SPAM, "Remote process indicates " + memoryUse + " bytes of memory used");
                    }
                }
                catch (SocketTimeoutException e) {
                    throw new TransientWorkerException("Remote process did not connect within timeout period", e);
                }
                catch (IOException e) {
                    throw new TransientWorkerException("Unable to communicate with worker", e);
                }
            }
            try {
                this.out.writeBoolean(true);
                this.out.writeObject(resultFile);
                this.out.writeObject(permutation);
                this.out.flush();
                Throwable t = (Throwable)this.in.readObject();
                if (t != null) {
                    logger.log(TreeLogger.ERROR, "Error from external worker", t);
                    throw new UnableToCompleteException();
                }
            }
            catch (IOException e) {
                logger.log(TreeLogger.WARN, "Lost communication with remote process", e);
                throw new TransientWorkerException("Lost communication with remote process", e);
            }
            catch (ClassNotFoundException e) {
                logger.log(TreeLogger.ERROR, "Unable to receive response", e);
                throw new UnableToCompleteException();
            }
        }

        @Override
        public String getName() {
            return "External worker " + (this.workerSocket != null ? this.workerSocket.getRemoteSocketAddress() : "unconnected");
        }

        @Override
        public void shutdown() {
            if (this.out != null) {
                try {
                    this.out.writeBoolean(false);
                    this.out.flush();
                    this.out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.workerSocket != null) {
                try {
                    this.workerSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private static class CountedServerSocket {
        private int accepts;
        private ServerSocket sock;

        public CountedServerSocket(ServerSocket sock, int maxAccepts) {
            assert (sock != null);
            assert (maxAccepts >= 1);
            this.accepts = maxAccepts;
            this.sock = sock;
        }

        public synchronized Socket accept() throws IOException {
            assert (this.accepts >= 0);
            if (this.accepts == 0) {
                throw new IllegalStateException("Too many calls to accept()");
            }
            try {
                Socket socket = this.sock.accept();
                return socket;
            }
            finally {
                if (--this.accepts == 0) {
                    this.sock.close();
                    this.sock = null;
                }
            }
        }
    }
}

