/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import java.net.MalformedURLException;
import java.net.URL;

class DevelModeTabKey {
    private final String remoteHost;
    private final String tabKey;
    private final String url;
    private final String userAgent;

    public DevelModeTabKey(String userAgent, String url, String tabKey, String remoteHost) {
        if (url == null) {
            url = "";
        }
        if (tabKey == null) {
            tabKey = "";
        }
        if (userAgent == null) {
            throw new IllegalArgumentException("userAgent cannot be null");
        }
        if (remoteHost == null) {
            throw new IllegalArgumentException("remoteHost cannot be null");
        }
        this.userAgent = userAgent;
        try {
            URL fullUrl = new URL(url);
            StringBuilder buf = new StringBuilder();
            buf.append(fullUrl.getProtocol()).append(':');
            if (fullUrl.getAuthority() != null && fullUrl.getAuthority().length() > 0) {
                buf.append("//").append(fullUrl.getAuthority());
            }
            if (fullUrl.getPath() != null) {
                buf.append(fullUrl.getPath());
            }
            url = buf.toString();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.url = url;
        this.tabKey = tabKey;
        this.remoteHost = remoteHost;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DevelModeTabKey other = (DevelModeTabKey)obj;
        return this.tabKey.equals(other.tabKey) && this.url.equals(other.url) && this.userAgent.equals(other.userAgent) && this.remoteHost.equals(other.remoteHost);
    }

    public String getRemoteSocket() {
        return this.remoteHost;
    }

    public String getTabKey() {
        return this.tabKey;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public int hashCode() {
        return this.remoteHost.hashCode() * 7 + this.tabKey.hashCode() * 11 + this.url.hashCode() * 13 + this.userAgent.hashCode() * 17;
    }
}

