/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.ArtifactSet;
import com.google.gwt.core.ext.linker.impl.StandardLinkerContext;
import com.google.gwt.dev.ArgProcessorBase;
import com.google.gwt.dev.BootStrapPlatform;
import com.google.gwt.dev.CompilerContext;
import com.google.gwt.dev.HeadlessUI;
import com.google.gwt.dev.ModuleHandle;
import com.google.gwt.dev.PrecompileTaskOptions;
import com.google.gwt.dev.PrecompileTaskOptionsImpl;
import com.google.gwt.dev.RebindCache;
import com.google.gwt.dev.SwingUI;
import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.dev.cfg.ModuleDefLoader;
import com.google.gwt.dev.javac.CompilationState;
import com.google.gwt.dev.javac.UnitCacheSingleton;
import com.google.gwt.dev.shell.ArtifactAcceptor;
import com.google.gwt.dev.shell.BrowserChannelServer;
import com.google.gwt.dev.shell.BrowserWidgetHost;
import com.google.gwt.dev.shell.ModuleSpaceHost;
import com.google.gwt.dev.shell.ShellModuleSpaceHost;
import com.google.gwt.dev.shell.remoteui.RemoteUI;
import com.google.gwt.dev.ui.DevModeUI;
import com.google.gwt.dev.ui.DoneCallback;
import com.google.gwt.dev.ui.DoneEvent;
import com.google.gwt.dev.util.BrowserInfo;
import com.google.gwt.dev.util.arg.ArgHandlerBindAddress;
import com.google.gwt.dev.util.arg.ArgHandlerEnableGeneratorResultCaching;
import com.google.gwt.dev.util.arg.ArgHandlerGenDir;
import com.google.gwt.dev.util.arg.ArgHandlerLogLevel;
import com.google.gwt.dev.util.arg.OptionBindAddress;
import com.google.gwt.dev.util.log.speedtracer.DevModeEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.util.tools.ArgHandlerFlag;
import com.google.gwt.util.tools.ArgHandlerString;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Semaphore;

public abstract class DevModeBase
implements DoneCallback {
    private static final boolean generatorResultCachingDisabled = System.getProperty("gwt.disableGeneratorResultCaching") != null;
    private static final Random RNG = new Random();
    protected TreeLogger.Type baseLogLevelForUI = null;
    protected String connectAddress;
    protected boolean isHttps;
    protected final HostedModeBaseOptions options;
    protected final CompilerContext.Builder compilerContextBuilder = new CompilerContext.Builder();
    protected CompilerContext compilerContext;
    protected DevModeUI ui = null;
    private final Semaphore blockUntilDone = new Semaphore(0);
    protected BrowserWidgetHost browserHost = new UiBrowserWidgetHostImpl();
    private boolean headlessMode = false;
    private Map<String, RebindCache> rebindCaches = null;
    private boolean started;
    private TreeLogger topLogger;

    public static String normalizeURL(String unknownUrlText, boolean isHttps, int port, String host) {
        if (unknownUrlText.contains("://")) {
            return unknownUrlText;
        }
        if (unknownUrlText.length() > 0 && unknownUrlText.charAt(0) == '/') {
            unknownUrlText = unknownUrlText.substring(1);
        }
        String protocol = "http";
        String portString = ":" + port;
        if (isHttps) {
            protocol = protocol + "s";
            if (port == 443) {
                portString = "";
            }
        } else if (port == 80) {
            portString = "";
        }
        return protocol + "://" + host + portString + "/" + unknownUrlText;
    }

    protected static String randomString() {
        StringBuilder buf = new StringBuilder(16);
        for (int i = 0; i < 16; ++i) {
            buf.append((char)RNG.nextInt(94) + 33);
        }
        return buf.toString();
    }

    public DevModeBase() {
        BootStrapPlatform.initHostedMode();
        BootStrapPlatform.applyPlatformHacks();
        this.compilerContext = this.compilerContextBuilder.build();
        this.options = this.createOptions();
    }

    public final void addStartupURL(String url) {
        this.options.addStartupURL(url);
    }

    public TreeLogger.Type getBaseLogLevelForUI() {
        if (this.baseLogLevelForUI == null) {
            throw new IllegalStateException("The ui must be created before calling this method.");
        }
        return this.baseLogLevelForUI;
    }

    public final int getPort() {
        return this.options.getPort();
    }

    public TreeLogger getTopLogger() {
        return this.topLogger;
    }

    @Override
    public void onDone() {
        this.setDone();
    }

    public final void run() {
        try {
            BootStrapPlatform.initGui();
            boolean success = this.startUp();
            this.ui.moduleLoadComplete(success);
            this.blockUntilDone.acquire();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.shutDown();
        }
    }

    public final void setPort(int port) {
        this.options.setPort(port);
    }

    public final void setRunTomcat(boolean run) {
        this.options.setNoServer(!run);
    }

    protected abstract HostedModeBaseOptions createOptions();

    protected final ShellModuleSpaceHost doCreateShellModuleSpaceHost(TreeLogger logger, CompilationState compilationState, ModuleDef moduleDef) throws UnableToCompleteException {
        ArtifactAcceptor artifactAcceptor = this.createArtifactAcceptor(logger, moduleDef);
        return new ShellModuleSpaceHost(logger, compilationState, moduleDef, this.options.getGenDir(), artifactAcceptor, this.getRebindCache(moduleDef.getName()));
    }

    protected abstract void doShutDownServer();

    protected boolean doSlowStartup() {
        return true;
    }

    protected abstract boolean doStartup();

    protected boolean doStartup(File persistentCacheDir) {
        this.connectAddress = this.options.getConnectAddress();
        this.ui.initialize(this.options.getLogLevel());
        this.topLogger = this.ui.getTopLogger();
        this.compilerContext = this.compilerContextBuilder.unitCache(UnitCacheSingleton.get(this.getTopLogger(), null, persistentCacheDir, this.options)).build();
        this.ui.setCallback(DoneEvent.getType(), this);
        this.ensureCodeServerListener();
        return true;
    }

    protected abstract int doStartUpServer();

    protected abstract void ensureCodeServerListener();

    protected String getHost() {
        return this.connectAddress;
    }

    protected void inferStartupUrls() {
    }

    protected final boolean isHeadless() {
        return this.headlessMode;
    }

    protected final StandardLinkerContext link(TreeLogger logger, ModuleDef module) throws UnableToCompleteException {
        TreeLogger linkLogger = logger.branch(TreeLogger.DEBUG, "Linking module '" + module.getName() + "'");
        StandardLinkerContext linkerStack = new StandardLinkerContext(linkLogger, module, this.compilerContext.getPublicResourceOracle(), this.options.getOutput());
        ArtifactSet artifacts = linkerStack.getArtifactsForPublicResources(logger, module);
        artifacts = linkerStack.invokeLegacyLinkers(linkLogger, artifacts);
        artifacts = linkerStack.invokeFinalLink(linkLogger, artifacts);
        this.produceOutput(linkLogger, linkerStack, artifacts, module, false);
        return linkerStack;
    }

    protected ModuleDef loadModule(TreeLogger logger, String moduleName, boolean refresh) throws UnableToCompleteException {
        ModuleDef moduleDef = ModuleDefLoader.loadFromClassPath(logger, moduleName, refresh);
        this.compilerContext = this.compilerContextBuilder.module(moduleDef).build();
        assert (moduleDef != null) : "Required module state is absent";
        return moduleDef;
    }

    protected abstract URL makeStartupUrl(String var1) throws UnableToCompleteException;

    protected abstract void produceOutput(TreeLogger var1, StandardLinkerContext var2, ArtifactSet var3, ModuleDef var4, boolean var5) throws UnableToCompleteException;

    protected final void setDone() {
        this.blockUntilDone.release();
    }

    protected final void setHeadless(boolean headlessMode) {
        this.headlessMode = headlessMode;
    }

    protected final void shutDown() {
        if (this.options.isNoServer()) {
            return;
        }
        this.doShutDownServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean startUp() {
        if (this.started) {
            throw new IllegalStateException("Startup code has already been run");
        }
        SpeedTracerLogger.Event startupEvent = SpeedTracerLogger.start(DevModeEventType.STARTUP, new String[0]);
        try {
            boolean bl;
            this.ui = this.createUI();
            this.started = true;
            if (!this.doStartup()) {
                this.getTopLogger().log(TreeLogger.ERROR, "shell failed in doStartup method");
                boolean bl2 = false;
                return bl2;
            }
            if (!this.options.isNoServer()) {
                int resultPort = this.doStartUpServer();
                if (resultPort < 0) {
                    this.getTopLogger().log(TreeLogger.ERROR, "shell failed in doStartupServer method");
                    boolean bl3 = false;
                    return bl3;
                }
                this.options.setPort(resultPort);
                this.getTopLogger().log(TreeLogger.TRACE, "Started web server on port " + resultPort);
            }
            if (this.options.getStartupURLs().isEmpty()) {
                this.inferStartupUrls();
            }
            if (this.options.getStartupURLs().isEmpty()) {
                this.warnAboutNoStartupUrls();
            }
            this.setStartupUrls(this.getTopLogger());
            if (!this.doSlowStartup()) {
                this.getTopLogger().log(TreeLogger.ERROR, "shell failed in doSlowStartup method");
                bl = false;
                return bl;
            }
            bl = true;
            return bl;
        }
        finally {
            startupEvent.end(new String[0]);
        }
    }

    protected abstract void warnAboutNoStartupUrls();

    private ArtifactAcceptor createArtifactAcceptor(TreeLogger logger, final ModuleDef module) throws UnableToCompleteException {
        final StandardLinkerContext linkerContext = this.link(logger, module);
        return new ArtifactAcceptor(){

            @Override
            public void accept(TreeLogger relinkLogger, ArtifactSet newArtifacts) throws UnableToCompleteException {
                DevModeBase.this.relink(relinkLogger, linkerContext, module, newArtifacts);
            }
        };
    }

    private DevModeUI createUI() {
        DevModeUI newUI = null;
        SpeedTracerLogger.Event createUIEvent = SpeedTracerLogger.start(DevModeEventType.CREATE_UI, new String[0]);
        if (this.headlessMode) {
            newUI = new HeadlessUI(this.options);
        } else if (this.options.useRemoteUI()) {
            try {
                newUI = new RemoteUI(this.options.getRemoteUIHost(), this.options.getRemoteUIHostPort(), this.options.getClientId());
                this.baseLogLevelForUI = TreeLogger.Type.TRACE;
            }
            catch (Throwable t) {
                System.err.println("Could not connect to remote UI listening at " + this.options.getRemoteUIHost() + ":" + this.options.getRemoteUIHostPort() + ". Using default UI instead.");
            }
        }
        if (newUI == null) {
            newUI = new SwingUI(this.options);
        }
        if (this.baseLogLevelForUI == null) {
            this.baseLogLevelForUI = TreeLogger.Type.INFO;
        }
        createUIEvent.end(new String[0]);
        return newUI;
    }

    private RebindCache getRebindCache(String moduleName) {
        RebindCache cache;
        if (generatorResultCachingDisabled) {
            return null;
        }
        if (this.rebindCaches == null) {
            this.rebindCaches = new HashMap<String, RebindCache>();
        }
        if ((cache = this.rebindCaches.get(moduleName)) == null) {
            cache = new RebindCache();
            this.rebindCaches.put(moduleName, cache);
        }
        return cache;
    }

    private void relink(TreeLogger logger, StandardLinkerContext linkerContext, ModuleDef module, ArtifactSet newlyGeneratedArtifacts) throws UnableToCompleteException {
        TreeLogger linkLogger = logger.branch(TreeLogger.DEBUG, "Relinking module '" + module.getName() + "'");
        ArtifactSet artifacts = linkerContext.invokeRelink(linkLogger, newlyGeneratedArtifacts);
        this.produceOutput(linkLogger, linkerContext, artifacts, module, true);
    }

    private void setStartupUrls(TreeLogger logger) {
        this.ensureCodeServerListener();
        HashMap<String, URL> startupUrls = new HashMap<String, URL>();
        for (String prenormalized : this.options.getStartupURLs()) {
            String startupURL = DevModeBase.normalizeURL(prenormalized, this.isHttps, this.getPort(), this.getHost());
            logger.log(TreeLogger.DEBUG, "URL " + prenormalized + " normalized as " + startupURL, null);
            try {
                URL url = this.makeStartupUrl(startupURL);
                startupUrls.put(prenormalized, url);
            }
            catch (UnableToCompleteException e) {
                logger.log(TreeLogger.ERROR, "Unable to process startup URL " + startupURL, null);
            }
        }
        this.ui.setStartupUrls(startupUrls);
    }

    protected static abstract class ArgProcessor
    extends ArgProcessorBase {
        public ArgProcessor(HostedModeBaseOptions options, boolean forceServer) {
            if (!forceServer) {
                this.registerHandler(new ArgHandlerNoServerFlag(options));
            }
            this.registerHandler(new ArgHandlerPort(options));
            this.registerHandler(new ArgHandlerEnableGeneratorResultCaching());
            this.registerHandler(new ArgHandlerLogDir(options));
            this.registerHandler(new ArgHandlerLogLevel(options));
            this.registerHandler(new ArgHandlerGenDir(options));
            this.registerHandler(new ArgHandlerBindAddress(options));
            this.registerHandler(new ArgHandlerCodeServerPort(options));
            this.registerHandler(new ArgHandlerRemoteUI(options));
        }
    }

    protected static interface OptionStartupURLs {
        public void addStartupURL(String var1);

        public List<String> getStartupURLs();
    }

    protected static interface OptionRemoteUI {
        public String getClientId();

        public String getRemoteUIHost();

        public int getRemoteUIHostPort();

        public void setClientId(String var1);

        public void setRemoteUIHost(String var1);

        public void setRemoteUIHostPort(int var1);

        public boolean useRemoteUI();
    }

    protected static interface OptionPort {
        public int getPort();

        public void setPort(int var1);
    }

    protected static interface OptionNoServer {
        public boolean isNoServer();

        public void setNoServer(boolean var1);
    }

    protected static interface OptionLogDir {
        public boolean alsoLogToFile();

        public File getLogDir();

        public File getLogFile(String var1);

        public void setLogFile(String var1);
    }

    protected static interface OptionCodeServerPort {
        public int getCodeServerPort();

        public void setCodeServerPort(int var1);
    }

    protected static class HostedModeBaseOptionsImpl
    extends PrecompileTaskOptionsImpl
    implements HostedModeBaseOptions {
        private String bindAddress;
        private int codeServerPort;
        private String connectAddress;
        private boolean isNoServer;
        private File logDir;
        private int port;
        private String remoteUIClientId;
        private String remoteUIHost;
        private int remoteUIHostPort;
        private final List<String> startupURLs = new ArrayList<String>();

        protected HostedModeBaseOptionsImpl() {
        }

        @Override
        public void addStartupURL(String url) {
            this.startupURLs.add(url);
        }

        @Override
        public boolean alsoLogToFile() {
            return this.logDir != null;
        }

        @Override
        public String getBindAddress() {
            return this.bindAddress;
        }

        @Override
        public String getClientId() {
            return this.remoteUIClientId;
        }

        @Override
        public int getCodeServerPort() {
            return this.codeServerPort;
        }

        @Override
        public String getConnectAddress() {
            return this.connectAddress;
        }

        @Override
        public File getLogDir() {
            return this.logDir;
        }

        @Override
        public File getLogFile(String sublog) {
            if (this.logDir == null) {
                return null;
            }
            return new File(this.logDir, sublog);
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public String getRemoteUIHost() {
            return this.remoteUIHost;
        }

        @Override
        public int getRemoteUIHostPort() {
            return this.remoteUIHostPort;
        }

        @Override
        public List<String> getStartupURLs() {
            return Collections.unmodifiableList(this.startupURLs);
        }

        @Override
        public boolean isNoServer() {
            return this.isNoServer;
        }

        @Override
        public void setBindAddress(String bindAddress) {
            this.bindAddress = bindAddress;
        }

        @Override
        public void setClientId(String clientId) {
            this.remoteUIClientId = clientId;
        }

        @Override
        public void setCodeServerPort(int port) {
            this.codeServerPort = port;
        }

        @Override
        public void setConnectAddress(String connectAddress) {
            this.connectAddress = connectAddress;
        }

        @Override
        public void setLogFile(String filename) {
            this.logDir = new File(filename);
        }

        @Override
        public void setNoServer(boolean isNoServer) {
            this.isNoServer = isNoServer;
        }

        @Override
        public void setPort(int port) {
            this.port = port;
        }

        @Override
        public void setRemoteUIHost(String remoteUIHost) {
            this.remoteUIHost = remoteUIHost;
        }

        @Override
        public void setRemoteUIHostPort(int remoteUIHostPort) {
            this.remoteUIHostPort = remoteUIHostPort;
        }

        @Override
        public boolean useRemoteUI() {
            return this.remoteUIHost != null;
        }
    }

    protected static interface HostedModeBaseOptions
    extends PrecompileTaskOptions,
    OptionLogDir,
    OptionNoServer,
    OptionPort,
    OptionCodeServerPort,
    OptionStartupURLs,
    OptionRemoteUI,
    OptionBindAddress {
    }

    protected static class ArgHandlerRemoteUI
    extends ArgHandlerString {
        private final HostedModeBaseOptions options;

        public ArgHandlerRemoteUI(HostedModeBaseOptions options) {
            this.options = options;
        }

        @Override
        public String getPurpose() {
            return "Sends Development Mode UI event information to the specified host and port.";
        }

        @Override
        public String getTag() {
            return "-remoteUI";
        }

        @Override
        public String[] getTagArgs() {
            return new String[]{"port-number:client-id-string | host-string:port-number:client-id-string"};
        }

        @Override
        public boolean isUndocumented() {
            return true;
        }

        @Override
        public boolean setString(String str) {
            String clientId;
            String[] split = str.split(":");
            String hostStr = "localhost";
            String portStr = null;
            if (split.length == 3) {
                hostStr = split[0];
                portStr = split[1];
                clientId = split[2];
            } else if (split.length == 2) {
                portStr = split[0];
                clientId = split[1];
            } else {
                return false;
            }
            this.options.setRemoteUIHost(hostStr);
            this.options.setClientId(clientId);
            try {
                this.options.setRemoteUIHostPort(Integer.parseInt(portStr));
            }
            catch (NumberFormatException nfe) {
                System.err.println("A port must be an integer");
                return false;
            }
            return true;
        }
    }

    protected static class ArgHandlerPort
    extends ArgHandlerString {
        private final OptionPort options;

        public ArgHandlerPort(OptionPort options) {
            this.options = options;
        }

        @Override
        public String[] getDefaultArgs() {
            return new String[]{this.getTag(), "8888"};
        }

        @Override
        public String getPurpose() {
            return "Specifies the TCP port for the embedded web server (defaults to 8888)";
        }

        @Override
        public String getTag() {
            return "-port";
        }

        @Override
        public String[] getTagArgs() {
            return new String[]{"port-number | \"auto\""};
        }

        @Override
        public boolean setString(String value) {
            if (value.equals("auto")) {
                this.options.setPort(0);
            } else {
                try {
                    this.options.setPort(Integer.parseInt(value));
                }
                catch (NumberFormatException e) {
                    System.err.println("A port must be an integer or \"auto\"");
                    return false;
                }
            }
            return true;
        }
    }

    protected static class ArgHandlerNoServerFlag
    extends ArgHandlerFlag {
        private final OptionNoServer options;

        public ArgHandlerNoServerFlag(OptionNoServer options) {
            this.options = options;
            this.addTagValue("-noserver", false);
        }

        @Override
        public String getPurposeSnippet() {
            return "Starts a servlet container serving the directory specified by the -war flag.";
        }

        @Override
        public String getLabel() {
            return "startServer";
        }

        @Override
        public boolean setFlag(boolean value) {
            this.options.setNoServer(!value);
            return true;
        }

        @Override
        public boolean getDefaultValue() {
            return !this.options.isNoServer();
        }
    }

    protected static class ArgHandlerLogDir
    extends ArgHandlerString {
        private final OptionLogDir options;

        public ArgHandlerLogDir(OptionLogDir options) {
            this.options = options;
        }

        @Override
        public String getPurpose() {
            return "Logs to a file in the given directory, as well as graphically";
        }

        @Override
        public String getTag() {
            return "-logdir";
        }

        @Override
        public String[] getTagArgs() {
            return new String[]{"directory"};
        }

        @Override
        public boolean setString(String value) {
            this.options.setLogFile(value);
            return true;
        }
    }

    protected static class ArgHandlerCodeServerPort
    extends ArgHandlerString {
        private static final String CODE_SERVER_PORT_TAG = "-codeServerPort";
        private static final String DEFAULT_PORT = "9997";
        private final OptionCodeServerPort options;

        public ArgHandlerCodeServerPort(OptionCodeServerPort options) {
            this.options = options;
        }

        @Override
        public String[] getDefaultArgs() {
            return new String[]{CODE_SERVER_PORT_TAG, DEFAULT_PORT};
        }

        @Override
        public String getPurpose() {
            return "Specifies the TCP port for the code server (defaults to 9997 for classic Dev Mode or 9876 for Super Dev Mode)";
        }

        @Override
        public String getTag() {
            return CODE_SERVER_PORT_TAG;
        }

        @Override
        public String[] getTagArgs() {
            return new String[]{"port-number | \"auto\""};
        }

        @Override
        public boolean setString(String value) {
            if (value.equals("auto")) {
                this.options.setCodeServerPort(0);
            } else {
                try {
                    this.options.setCodeServerPort(Integer.parseInt(value));
                }
                catch (NumberFormatException e) {
                    System.err.println("A port must be an integer or \"auto\"");
                    return false;
                }
            }
            return true;
        }
    }

    public class UiBrowserWidgetHostImpl
    implements BrowserWidgetHost {
        @Override
        public ModuleHandle createModuleLogger(String moduleName, String userAgent, String url, String tabKey, String sessionKey, BrowserChannelServer serverChannel, byte[] userAgentIcon) {
            if (sessionKey == null) {
                sessionKey = DevModeBase.randomString();
            }
            TreeLogger.Type maxLevel = DevModeBase.this.options.getLogLevel();
            String agentTag = BrowserInfo.getShortName(userAgent);
            String remoteSocket = serverChannel.getRemoteEndpoint();
            ModuleHandle module = DevModeBase.this.ui.getModuleLogger(userAgent, remoteSocket, url, tabKey, moduleName, sessionKey, agentTag, userAgentIcon, maxLevel);
            return module;
        }

        @Override
        public ModuleSpaceHost createModuleSpaceHost(ModuleHandle module, String moduleName) throws UnableToCompleteException {
            SpeedTracerLogger.Event moduleSpaceHostCreateEvent = SpeedTracerLogger.start(DevModeEventType.MODULE_SPACE_HOST_CREATE, "Module Name", moduleName);
            TreeLogger logger = module.getLogger();
            try {
                ShellModuleSpaceHost host;
                ModuleDef moduleDef = DevModeBase.this.loadModule(logger, moduleName, true);
                assert (moduleDef != null);
                CompilationState compilationState = moduleDef.getCompilationState(logger, DevModeBase.this.compilerContext);
                ShellModuleSpaceHost shellModuleSpaceHost = host = DevModeBase.this.doCreateShellModuleSpaceHost(logger, compilationState, moduleDef);
                return shellModuleSpaceHost;
            }
            catch (RuntimeException e) {
                logger.log(TreeLogger.ERROR, "Exception initializing module", e);
                module.unload();
                throw e;
            }
            finally {
                moduleSpaceHostCreateEvent.end(new String[0]);
            }
        }
    }
}

