/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import com.google.gwt.core.ext.ServletContainer;
import com.google.gwt.core.ext.ServletContainerLauncher;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.ArtifactSet;
import com.google.gwt.core.ext.linker.impl.StandardLinkerContext;
import com.google.gwt.dev.CompilerOptions;
import com.google.gwt.dev.DevModeBase;
import com.google.gwt.dev.ServletValidator;
import com.google.gwt.dev.ServletWriter;
import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.dev.resource.impl.ResourceOracleImpl;
import com.google.gwt.dev.shell.BrowserListener;
import com.google.gwt.dev.shell.CodeServerListener;
import com.google.gwt.dev.shell.OophmSessionHandler;
import com.google.gwt.dev.shell.SuperDevListener;
import com.google.gwt.dev.shell.jetty.JettyLauncher;
import com.google.gwt.dev.ui.RestartServerCallback;
import com.google.gwt.dev.ui.RestartServerEvent;
import com.google.gwt.dev.util.InstalledHelpInfo;
import com.google.gwt.dev.util.Util;
import com.google.gwt.dev.util.arg.ArgHandlerDeployDir;
import com.google.gwt.dev.util.arg.ArgHandlerExtraDir;
import com.google.gwt.dev.util.arg.ArgHandlerFilterJsInteropExports;
import com.google.gwt.dev.util.arg.ArgHandlerGenerateJsInteropExports;
import com.google.gwt.dev.util.arg.ArgHandlerIncrementalCompile;
import com.google.gwt.dev.util.arg.ArgHandlerMethodNameDisplayMode;
import com.google.gwt.dev.util.arg.ArgHandlerModuleName;
import com.google.gwt.dev.util.arg.ArgHandlerModulePathPrefix;
import com.google.gwt.dev.util.arg.ArgHandlerScriptStyle;
import com.google.gwt.dev.util.arg.ArgHandlerSetProperties;
import com.google.gwt.dev.util.arg.ArgHandlerSourceLevel;
import com.google.gwt.dev.util.arg.ArgHandlerStrict;
import com.google.gwt.dev.util.arg.ArgHandlerWarDir;
import com.google.gwt.dev.util.arg.ArgHandlerWorkDirOptional;
import com.google.gwt.dev.util.arg.OptionModulePathPrefix;
import com.google.gwt.dev.util.log.speedtracer.DevModeEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.util.tools.ArgHandlerFlag;
import com.google.gwt.util.tools.ArgHandlerString;
import com.google.gwt.util.tools.Utility;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.BindException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class DevMode
extends DevModeBase
implements RestartServerCallback {
    private static final Pattern STARTUP_FILE_PATTERN = Pattern.compile(".*\\.(html|jsp)", 2);
    protected CodeServerListener listener;
    protected final HostedModeOptions options;
    private ServletContainer server;
    private final Map<String, ModuleDef> startupModules;
    private boolean tempWorkDir;

    public static void main(String[] args) {
        DevMode hostedMode = new DevMode();
        if (new ArgProcessor(hostedMode.options).processArgs(args)) {
            hostedMode.run();
            System.exit(0);
        }
        System.exit(-1);
    }

    protected DevMode() {
        this.options = (HostedModeOptionsImpl)((DevModeBase)this).options;
        this.startupModules = new LinkedHashMap<String, ModuleDef>();
        this.tempWorkDir = false;
    }

    @Override
    public void onRestartServer(TreeLogger logger) {
        try {
            this.server.refresh();
        }
        catch (UnableToCompleteException unableToCompleteException) {
            // empty catch block
        }
    }

    @Override
    protected HostedModeOptions createOptions() {
        HostedModeOptionsImpl hostedModeOptions = new HostedModeOptionsImpl();
        hostedModeOptions.setIncrementalCompileEnabled(true);
        this.compilerContext = this.compilerContextBuilder.options(hostedModeOptions).build();
        return hostedModeOptions;
    }

    @Override
    protected void doShutDownServer() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (UnableToCompleteException unableToCompleteException) {
                // empty catch block
            }
            this.server = null;
        }
        if (this.tempWorkDir) {
            Util.recursiveDelete(this.options.getWorkDir(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doSlowStartup() {
        boolean bl = this.tempWorkDir = this.options.getWorkDir() == null;
        if (this.tempWorkDir) {
            try {
                this.options.setWorkDir(Utility.makeTemporaryDirectory(null, "gwtc"));
            }
            catch (IOException e) {
                System.err.println("Unable to create hosted mode work directory");
                e.printStackTrace();
                return false;
            }
        }
        TreeLogger branch = this.getTopLogger().branch(TreeLogger.TRACE, "Linking modules");
        SpeedTracerLogger.Event slowStartupEvent = SpeedTracerLogger.start(DevModeEventType.SLOW_STARTUP, new String[0]);
        try {
            for (ModuleDef module : this.startupModules.values()) {
                TreeLogger loadLogger = branch.branch(TreeLogger.DEBUG, "Bootstrap link for command-line module '" + module.getCanonicalName() + "'");
                this.link(loadLogger, module);
            }
        }
        catch (UnableToCompleteException e) {
            boolean bl2 = false;
            return bl2;
        }
        finally {
            slowStartupEvent.end(new String[0]);
        }
        return true;
    }

    @Override
    protected boolean doStartup() {
        Thread scanThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ResourceOracleImpl.preload(TreeLogger.NULL);
            }
        });
        scanThread.setDaemon(true);
        scanThread.setPriority(3);
        scanThread.start();
        File persistentCacheDir = null;
        if (this.options.getWarDir() != null && !this.options.getWarDir().getName().endsWith(".jar")) {
            persistentCacheDir = new File(this.options.getWarDir(), "../");
        }
        if (!super.doStartup(persistentCacheDir)) {
            return false;
        }
        ServletValidator servletValidator = null;
        ServletWriter servletWriter = null;
        File webXml = new File(this.options.getWarDir(), "WEB-INF/web.xml");
        if (!this.options.isNoServer()) {
            if (webXml.exists()) {
                servletValidator = ServletValidator.create(this.getTopLogger(), webXml);
            } else {
                servletWriter = new ServletWriter();
            }
        }
        TreeLogger branch = this.getTopLogger().branch(TreeLogger.TRACE, "Loading modules");
        try {
            for (String moduleName : this.options.getModuleNames()) {
                TreeLogger moduleBranch = branch.branch(TreeLogger.TRACE, moduleName);
                ModuleDef module = this.loadModule(moduleBranch, moduleName, false);
                this.startupModules.put(module.getName(), module);
                if (this.options.isNoServer()) continue;
                this.validateServletTags(moduleBranch, servletValidator, servletWriter, module);
            }
            if (servletWriter != null) {
                servletWriter.realize(webXml);
            }
        }
        catch (IOException e) {
            this.getTopLogger().log(TreeLogger.WARN, "Unable to generate '" + webXml.getAbsolutePath() + "'");
        }
        catch (UnableToCompleteException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doStartUpServer() {
        File warDir = this.options.getWarDir();
        if (!warDir.exists() && !warDir.mkdirs()) {
            this.getTopLogger().log(TreeLogger.ERROR, "Unable to create war directory " + warDir);
            return -1;
        }
        SpeedTracerLogger.Event jettyStartupEvent = SpeedTracerLogger.start(DevModeEventType.JETTY_STARTUP, new String[0]);
        boolean clearCallback = true;
        try {
            this.ui.setCallback(RestartServerEvent.getType(), this);
            ServletContainerLauncher scl = this.options.getServletContainerLauncher();
            TreeLogger serverLogger = this.ui.getWebServerLogger(this.getWebServerName(), scl.getIconBytes());
            String sclArgs = this.options.getServletContainerLauncherArgs();
            if (sclArgs != null && !scl.processArguments(serverLogger, sclArgs)) {
                int n = -1;
                return n;
            }
            this.isHttps = scl.isSecure();
            if (this.isHttps) {
                this.ui.setWebServerSecure(serverLogger);
            }
            if (scl instanceof JettyLauncher) {
                JettyLauncher jetty = (JettyLauncher)scl;
                jetty.setBaseRequestLogLevel(this.getBaseLogLevelForUI());
            }
            scl.setBindAddress(this.options.getBindAddress());
            if (serverLogger.isLoggable(TreeLogger.TRACE)) {
                serverLogger.log(TreeLogger.TRACE, "Starting HTTP on port " + this.getPort(), null);
            }
            this.server = scl.start(serverLogger, this.getPort(), this.options.getWarDir());
            assert (this.server != null);
            clearCallback = false;
            int n = this.server.getPort();
            return n;
        }
        catch (BindException e) {
            System.err.println("Port " + this.options.getBindAddress() + ':' + this.getPort() + " is already in use; you probably still have another session active");
        }
        catch (Exception e) {
            System.err.println("Unable to start embedded HTTP server");
            e.printStackTrace();
        }
        finally {
            jettyStartupEvent.end(new String[0]);
            if (clearCallback) {
                this.ui.setCallback(RestartServerEvent.getType(), null);
            }
        }
        return -1;
    }

    @Override
    protected void ensureCodeServerListener() {
        if (this.listener == null) {
            this.listener = this.options.isSuperDevMode() ? new SuperDevListener(this.getTopLogger(), this.options) : new BrowserListener(this.getTopLogger(), this.options, new OophmSessionHandler(this.getTopLogger(), this.browserHost));
            this.listener.start();
        }
    }

    protected String getWebServerName() {
        return this.options.getServletContainerLauncher().getName();
    }

    @Override
    protected void inferStartupUrls() {
        File warDir = this.options.getWarDir();
        if (!warDir.exists()) {
            return;
        }
        for (File htmlFile : warDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return STARTUP_FILE_PATTERN.matcher(name).matches();
            }
        })) {
            this.options.addStartupURL(htmlFile.getName());
        }
    }

    @Override
    protected ModuleDef loadModule(TreeLogger logger, String moduleName, boolean refresh) throws UnableToCompleteException {
        if (this.startupModules.containsKey(moduleName)) {
            return this.startupModules.remove(moduleName);
        }
        return super.loadModule(logger, moduleName, refresh);
    }

    @Override
    protected URL makeStartupUrl(String url) throws UnableToCompleteException {
        return this.listener.makeStartupUrl(url);
    }

    @Override
    protected synchronized void produceOutput(TreeLogger logger, StandardLinkerContext linkerStack, ArtifactSet artifacts, ModuleDef module, boolean isRelink) throws UnableToCompleteException {
        this.listener.writeCompilerOutput(linkerStack, artifacts, module, isRelink);
    }

    @Override
    protected void warnAboutNoStartupUrls() {
        this.getTopLogger().log(TreeLogger.WARN, "No startup URLs supplied and no plausible ones found -- use -startupUrl");
    }

    private void validateServletTags(TreeLogger logger, ServletValidator servletValidator, ServletWriter servletWriter, ModuleDef module) {
        String[] servletPaths = module.getServletPaths();
        if (servletPaths.length == 0) {
            return;
        }
        TreeLogger servletLogger = logger.branch(TreeLogger.DEBUG, "Validating <servlet> tags for module '" + module.getName() + "'", null, new InstalledHelpInfo("servletMappings.html"));
        for (String servletPath : servletPaths) {
            String servletClass = module.findServletForPath(servletPath);
            assert (servletClass != null);
            servletPath = "/" + module.getName() + servletPath;
            if (servletValidator == null) {
                servletWriter.addMapping(servletClass, servletPath);
                continue;
            }
            servletValidator.validate(servletLogger, servletClass, servletPath);
        }
    }

    protected static interface OptionSuperDevMode {
        public boolean isSuperDevMode();

        public void setSuperDevMode(boolean var1);
    }

    protected static class HostedModeOptionsImpl
    extends DevModeBase.HostedModeBaseOptionsImpl
    implements HostedModeOptions {
        private File deployDir;
        private File extraDir;
        private int localWorkers;
        private ServletContainerLauncher scl;
        private String sclArgs;
        private boolean sdm = true;
        private File moduleBaseDir;
        private String modulePathPrefix = "";
        private File warDir;
        private boolean closureCompilerFormatEnabled;

        protected HostedModeOptionsImpl() {
        }

        @Override
        public File getDeployDir() {
            return this.deployDir == null ? new File(this.warDir, "WEB-INF/deploy") : this.deployDir;
        }

        @Override
        public File getExtraDir() {
            return this.extraDir;
        }

        @Override
        public int getLocalWorkers() {
            return this.localWorkers;
        }

        @Override
        public File getSaveSourceOutput() {
            return null;
        }

        @Override
        public ServletContainerLauncher getServletContainerLauncher() {
            return this.scl;
        }

        @Override
        public File getModuleBaseDir() {
            return this.moduleBaseDir;
        }

        @Override
        public String getServletContainerLauncherArgs() {
            return this.sclArgs;
        }

        @Override
        public File getWarDir() {
            return this.warDir;
        }

        @Override
        public boolean isSuperDevMode() {
            return this.sdm;
        }

        @Override
        public void setDeployDir(File deployDir) {
            this.deployDir = deployDir;
        }

        @Override
        public void setExtraDir(File extraDir) {
            this.extraDir = extraDir;
        }

        @Override
        public void setLocalWorkers(int localWorkers) {
            this.localWorkers = localWorkers;
        }

        @Override
        public void setModulePathPrefix(String prefix) {
            if (!prefix.equals(this.modulePathPrefix)) {
                this.modulePathPrefix = prefix;
                this.updateModuleBaseDir();
            }
        }

        @Deprecated
        public void setOutDir(File outDir) {
            this.setWarDir(outDir);
        }

        @Override
        public void setSaveSourceOutput(File debugDir) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSuperDevMode(boolean sdm) {
            this.sdm = sdm;
        }

        @Override
        public void setServletContainerLauncher(ServletContainerLauncher scl) {
            this.scl = scl;
        }

        @Override
        public void setServletContainerLauncherArgs(String args) {
            this.sclArgs = args;
        }

        @Override
        public void setWarDir(File warDir) {
            this.warDir = warDir;
            this.updateModuleBaseDir();
        }

        private void updateModuleBaseDir() {
            this.moduleBaseDir = new File(this.warDir, this.modulePathPrefix);
        }

        @Override
        public boolean isClosureCompilerFormatEnabled() {
            return this.closureCompilerFormatEnabled;
        }

        @Override
        public void setClosureCompilerFormatEnabled(boolean enabled) {
            this.closureCompilerFormatEnabled = enabled;
        }
    }

    protected static class ArgProcessor
    extends DevModeBase.ArgProcessor {
        public ArgProcessor(HostedModeOptions options) {
            super(options, false);
            this.registerHandler(new ArgHandlerSuperDevMode(options));
            this.registerHandler(new ArgHandlerServer(options));
            this.registerHandler(new ArgHandlerStartupURLs(options));
            this.registerHandler(new ArgHandlerWarDir(options));
            this.registerHandler(new ArgHandlerDeployDir(options));
            this.registerHandler(new ArgHandlerExtraDir(options));
            this.registerHandler(new ArgHandlerModulePathPrefix(options));
            this.registerHandler(new ArgHandlerWorkDirOptional(options));
            this.registerHandler(new ArgHandlerMethodNameDisplayMode(options));
            this.registerHandler(new ArgHandlerSourceLevel(options));
            this.registerHandler(new ArgHandlerGenerateJsInteropExports(options));
            this.registerHandler(new ArgHandlerFilterJsInteropExports(options));
            this.registerHandler(new ArgHandlerIncrementalCompile(options));
            this.registerHandler(new ArgHandlerScriptStyle(options));
            this.registerHandler(new ArgHandlerStrict(options));
            this.registerHandler(new ArgHandlerModuleName(options){

                @Override
                public String getPurpose() {
                    return super.getPurpose() + " to host";
                }
            });
            this.registerHandler(new ArgHandlerSetProperties(options));
        }

        @Override
        protected String getName() {
            return DevMode.class.getName();
        }
    }

    protected static class ArgHandlerStartupURLs
    extends ArgHandlerString {
        private final DevModeBase.OptionStartupURLs options;

        public ArgHandlerStartupURLs(DevModeBase.OptionStartupURLs options) {
            this.options = options;
        }

        @Override
        public String getPurpose() {
            return "Automatically launches the specified URL";
        }

        @Override
        public String getTag() {
            return "-startupUrl";
        }

        @Override
        public String[] getTagArgs() {
            return new String[]{"url"};
        }

        @Override
        public boolean setString(String arg) {
            this.options.addStartupURL(arg);
            return true;
        }
    }

    protected static class ArgHandlerServer
    extends ArgHandlerString {
        private static final String DEFAULT_SCL = JettyLauncher.class.getName();
        private HostedModeOptions options;

        public ArgHandlerServer(HostedModeOptions options) {
            this.options = options;
        }

        @Override
        public String[] getDefaultArgs() {
            if (this.options.isNoServer()) {
                return null;
            }
            return new String[]{this.getTag(), DEFAULT_SCL};
        }

        @Override
        public String getPurpose() {
            return "Specify a different embedded web server to run (must implement ServletContainerLauncher)";
        }

        @Override
        public String getTag() {
            return "-server";
        }

        @Override
        public String[] getTagArgs() {
            return new String[]{"servletContainerLauncher[:args]"};
        }

        @Override
        public boolean setString(String arg) {
            Exception t;
            String sclClassName;
            String sclArgs;
            this.options.setNoServer(false);
            int idx = arg.indexOf(58);
            if (idx >= 0) {
                sclArgs = arg.substring(idx + 1);
                sclClassName = arg.substring(0, idx);
            } else {
                sclArgs = null;
                sclClassName = arg;
            }
            if (sclClassName.length() == 0) {
                sclClassName = DEFAULT_SCL;
            }
            try {
                Class<?> clazz = Class.forName(sclClassName, true, Thread.currentThread().getContextClassLoader());
                Class<ServletContainerLauncher> sclClass = clazz.asSubclass(ServletContainerLauncher.class);
                this.options.setServletContainerLauncher(sclClass.newInstance());
                this.options.setServletContainerLauncherArgs(sclArgs);
                return true;
            }
            catch (ClassCastException e) {
                t = e;
            }
            catch (ClassNotFoundException e) {
                t = e;
            }
            catch (InstantiationException e) {
                t = e;
            }
            catch (IllegalAccessException e) {
                t = e;
            }
            System.err.println("Unable to load server class '" + sclClassName + "'");
            t.printStackTrace();
            return false;
        }
    }

    protected static class ArgHandlerSuperDevMode
    extends ArgHandlerFlag {
        private final HostedModeOptions options;

        public ArgHandlerSuperDevMode(HostedModeOptions options) {
            this.options = options;
            this.addTagValue("-superDevMode", true);
        }

        @Override
        public boolean getDefaultValue() {
            return true;
        }

        @Override
        public String getLabel() {
            return "superDevMode";
        }

        @Override
        public String getPurposeSnippet() {
            return "Runs Super Dev Mode instead of classic Development Mode.";
        }

        @Override
        public boolean setFlag(boolean value) {
            this.options.setSuperDevMode(value);
            if (this.options.isSuperDevMode()) {
                this.options.setIncrementalCompileEnabled(true);
            }
            return true;
        }
    }

    public static interface HostedModeOptions
    extends DevModeBase.HostedModeBaseOptions,
    CompilerOptions,
    OptionSuperDevMode,
    OptionModulePathPrefix {
        public ServletContainerLauncher getServletContainerLauncher();

        public String getServletContainerLauncherArgs();

        public void setServletContainerLauncher(ServletContainerLauncher var1);

        public void setServletContainerLauncherArgs(String var1);
    }
}

