/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import com.google.gwt.dev.MinimalRebuildCache;
import com.google.gwt.dev.PrecompileTaskOptions;
import com.google.gwt.dev.PrecompileTaskOptionsImpl;
import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.dev.javac.CompilationErrorsIndex;
import com.google.gwt.dev.javac.CompilationErrorsIndexImpl;
import com.google.gwt.dev.javac.MemoryUnitCache;
import com.google.gwt.dev.javac.UnitCache;
import com.google.gwt.dev.resource.ResourceOracle;

public class CompilerContext {
    private ResourceOracle buildResourceOracle;
    private CompilationErrorsIndex compilationErrorsIndex = new CompilationErrorsIndexImpl();
    private MinimalRebuildCache minimalRebuildCache = new MinimalRebuildCache();
    private ModuleDef module;
    private PrecompileTaskOptions options = new PrecompileTaskOptionsImpl();
    private ResourceOracle publicResourceOracle;
    private ResourceOracle sourceResourceOracle;
    private UnitCache unitCache = new MemoryUnitCache();

    public ResourceOracle getBuildResourceOracle() {
        return this.buildResourceOracle;
    }

    public CompilationErrorsIndex getCompilationErrorsIndex() {
        return this.compilationErrorsIndex;
    }

    public MinimalRebuildCache getMinimalRebuildCache() {
        return this.minimalRebuildCache;
    }

    public ModuleDef getModule() {
        return this.module;
    }

    public PrecompileTaskOptions getOptions() {
        return this.options;
    }

    public ResourceOracle getPublicResourceOracle() {
        return this.publicResourceOracle;
    }

    public ResourceOracle getSourceResourceOracle() {
        return this.sourceResourceOracle;
    }

    public UnitCache getUnitCache() {
        return this.unitCache;
    }

    public static class Builder {
        private ResourceOracle buildResourceOracle;
        private CompilationErrorsIndex compilationErrorsIndex;
        private MinimalRebuildCache minimalRebuildCache = new MinimalRebuildCache();
        private ModuleDef module;
        private PrecompileTaskOptions options = new PrecompileTaskOptionsImpl();
        private ResourceOracle publicResourceOracle;
        private ResourceOracle sourceResourceOracle;
        private UnitCache unitCache = new MemoryUnitCache();

        public CompilerContext build() {
            if (this.options != null && this.module != null) {
                this.module.getProperties().setProperties(this.options.getProperties());
            }
            this.initializeResourceOracles();
            this.initializeCompilationErrorIndexes();
            CompilerContext compilerContext = new CompilerContext();
            compilerContext.buildResourceOracle = this.buildResourceOracle;
            compilerContext.minimalRebuildCache = this.minimalRebuildCache;
            compilerContext.module = this.module;
            compilerContext.options = this.options;
            compilerContext.publicResourceOracle = this.publicResourceOracle;
            compilerContext.sourceResourceOracle = this.sourceResourceOracle;
            compilerContext.compilationErrorsIndex = this.compilationErrorsIndex;
            compilerContext.unitCache = this.unitCache;
            return compilerContext;
        }

        public Builder minimalRebuildCache(MinimalRebuildCache minimalRebuildCache) {
            assert (minimalRebuildCache != null);
            this.minimalRebuildCache = minimalRebuildCache;
            return this;
        }

        public Builder module(ModuleDef module) {
            this.module = module;
            return this;
        }

        public Builder options(PrecompileTaskOptions options) {
            this.options = options;
            return this;
        }

        public Builder unitCache(UnitCache unitCache) {
            this.unitCache = unitCache;
            return this;
        }

        private void initializeCompilationErrorIndexes() {
            this.compilationErrorsIndex = new CompilationErrorsIndexImpl();
        }

        private void initializeResourceOracles() {
            if (this.module != null) {
                this.sourceResourceOracle = this.module.getSourceResourceOracle();
                this.buildResourceOracle = this.module.getBuildResourceOracle();
                this.publicResourceOracle = this.module.getPublicResourceOracle();
            } else {
                this.sourceResourceOracle = null;
                this.buildResourceOracle = null;
                this.publicResourceOracle = null;
            }
        }
    }
}

