/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.ArtifactSet;
import com.google.gwt.dev.CompilePerms;
import com.google.gwt.dev.CompileTaskRunner;
import com.google.gwt.dev.CompilerContext;
import com.google.gwt.dev.CompilerOptions;
import com.google.gwt.dev.CompilerOptionsImpl;
import com.google.gwt.dev.Link;
import com.google.gwt.dev.MinimalRebuildCache;
import com.google.gwt.dev.NullRebuildCache;
import com.google.gwt.dev.Permutation;
import com.google.gwt.dev.Precompilation;
import com.google.gwt.dev.Precompile;
import com.google.gwt.dev.PrecompileTaskArgProcessor;
import com.google.gwt.dev.PrecompileTaskOptions;
import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.dev.cfg.ModuleDefLoader;
import com.google.gwt.dev.javac.UnitCache;
import com.google.gwt.dev.javac.UnitCacheSingleton;
import com.google.gwt.dev.jjs.PermutationResult;
import com.google.gwt.dev.js.JsNamespaceOption;
import com.google.gwt.dev.util.Memory;
import com.google.gwt.dev.util.PersistenceBackedObject;
import com.google.gwt.dev.util.Util;
import com.google.gwt.dev.util.arg.ArgHandlerDeployDir;
import com.google.gwt.dev.util.arg.ArgHandlerExtraDir;
import com.google.gwt.dev.util.arg.ArgHandlerIncrementalCompile;
import com.google.gwt.dev.util.arg.ArgHandlerLocalWorkers;
import com.google.gwt.dev.util.arg.ArgHandlerSaveSourceOutput;
import com.google.gwt.dev.util.arg.ArgHandlerWarDir;
import com.google.gwt.dev.util.arg.ArgHandlerWorkDirOptional;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.util.tools.Utility;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Compiler {
    public static UnitCache getOrCreateUnitCache(TreeLogger logger, CompilerOptions options) {
        File persistentUnitCacheDir = null;
        if (options.getWarDir() != null && options.getWarDir().isDirectory()) {
            persistentUnitCacheDir = new File(options.getWarDir(), "../");
        }
        return UnitCacheSingleton.get(logger, null, persistentUnitCacheDir, options);
    }

    public static void main(String[] args) {
        CompileTaskRunner.CompileTask task;
        Memory.initialize();
        if (System.getProperty("gwt.jjs.dumpAst") != null) {
            System.out.println("Will dump AST to: " + System.getProperty("gwt.jjs.dumpAst"));
        }
        SpeedTracerLogger.init();
        final CompilerOptionsImpl options = new CompilerOptionsImpl();
        if (new ArgProcessor(options).processArgs(args) && CompileTaskRunner.runWithAppropriateLogger(options, task = new CompileTaskRunner.CompileTask(){

            @Override
            public boolean run(TreeLogger logger) throws UnableToCompleteException {
                return Compiler.compile(logger, options);
            }
        })) {
            System.exit(0);
        }
        System.exit(1);
    }

    public static boolean compile(TreeLogger logger, CompilerOptions compilerOptions) throws UnableToCompleteException {
        ArrayList<ModuleDef> moduleDefs = new ArrayList<ModuleDef>();
        for (String moduleName : compilerOptions.getModuleNames()) {
            moduleDefs.add(ModuleDefLoader.loadFromClassPath(logger, moduleName, true));
        }
        boolean result = true;
        for (ModuleDef moduleDef : moduleDefs) {
            result &= Compiler.compile(logger, compilerOptions, moduleDef);
        }
        return result;
    }

    public static boolean compile(TreeLogger logger, CompilerOptions compilerOptions, ModuleDef moduleDef) throws UnableToCompleteException {
        MinimalRebuildCache minimalRebuildCache = compilerOptions.isIncrementalCompileEnabled() ? new MinimalRebuildCache() : new NullRebuildCache();
        return Compiler.compile(logger, compilerOptions, minimalRebuildCache, moduleDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compile(TreeLogger logger, CompilerOptions compilerOptions, MinimalRebuildCache minimalRebuildCache, ModuleDef moduleDef) throws UnableToCompleteException {
        CompilerOptionsImpl options = new CompilerOptionsImpl(compilerOptions);
        boolean tempWorkDir = false;
        try {
            if (options.getWorkDir() == null) {
                options.setWorkDir(Utility.makeTemporaryDirectory(null, "gwtc"));
                tempWorkDir = true;
            }
            if ((options.isSoycEnabled() || options.isJsonSoycEnabled()) && options.getExtraDir() == null) {
                options.setExtraDir(new File("extras"));
            }
            if (options.isIncrementalCompileEnabled()) {
                options.setClusterSimilarFunctions(false);
                options.setOptimizationLevel(0);
                options.setRunAsyncEnabled(false);
                options.setNamespace(JsNamespaceOption.NONE);
            }
            CompilerContext compilerContext = new CompilerContext.Builder().options(options).minimalRebuildCache(minimalRebuildCache).unitCache(Compiler.getOrCreateUnitCache(logger, options)).module(moduleDef).build();
            String moduleName = moduleDef.getCanonicalName();
            if (options.isValidateOnly()) {
                if (!Precompile.validate(logger, compilerContext)) {
                    boolean bl = false;
                    return bl;
                }
            } else {
                long beforeCompileMs = System.currentTimeMillis();
                TreeLogger branch = logger.branch(TreeLogger.INFO, "Compiling module " + moduleName);
                Precompilation precompilation = Precompile.precompile(branch, compilerContext);
                if (precompilation == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean embedSourcesContent = compilerContext.getModule().shouldEmbedSourceMapContents();
                if (!options.shouldSaveSource() && !embedSourcesContent) {
                    precompilation.removeSourceArtifacts(branch);
                }
                SpeedTracerLogger.Event compilePermutationsEvent = SpeedTracerLogger.start(CompilerEventType.COMPILE_PERMUTATIONS, new String[0]);
                Permutation[] allPerms = precompilation.getPermutations();
                List<PersistenceBackedObject<PermutationResult>> resultFiles = CompilePerms.makeResultFiles(options.getCompilerWorkDir(moduleName), allPerms, options);
                CompilePerms.compile(branch, compilerContext, precompilation, allPerms, options.getLocalWorkers(), resultFiles);
                compilePermutationsEvent.end(new String[0]);
                ArtifactSet generatedArtifacts = precompilation.getGeneratedArtifacts();
                PrecompileTaskOptions precompileOptions = precompilation.getUnifiedAst().getOptions();
                precompilation = null;
                long afterCompileMs = System.currentTimeMillis();
                double compileSeconds = (double)(afterCompileMs - beforeCompileMs) / 1000.0;
                branch.log(TreeLogger.INFO, String.format("Compilation succeeded -- %.3fs", compileSeconds));
                long beforeLinkMs = System.currentTimeMillis();
                SpeedTracerLogger.Event linkEvent = SpeedTracerLogger.start(CompilerEventType.LINK, new String[0]);
                File absPath = new File(options.getWarDir(), moduleDef.getName());
                absPath = absPath.getAbsoluteFile();
                String logMessage = "Linking into " + absPath;
                if (options.getExtraDir() != null) {
                    File absExtrasPath = new File(options.getExtraDir(), moduleDef.getName());
                    absExtrasPath = absExtrasPath.getAbsoluteFile();
                    logMessage = logMessage + "; Writing extras to " + absExtrasPath;
                }
                Link.link(logger.branch(TreeLogger.TRACE, logMessage), moduleDef, moduleDef.getPublicResourceOracle(), generatedArtifacts, allPerms, resultFiles, Sets.newHashSet(), precompileOptions, options);
                linkEvent.end(new String[0]);
                long afterLinkMs = System.currentTimeMillis();
                double linkSeconds = (double)(afterLinkMs - beforeLinkMs) / 1000.0;
                branch.log(TreeLogger.INFO, String.format("Linking succeeded -- %.3fs", linkSeconds));
            }
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "Unable to create compiler work directory", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (tempWorkDir) {
                Util.recursiveDelete(options.getWorkDir(), false);
            }
        }
        return true;
    }

    static class ArgProcessor
    extends PrecompileTaskArgProcessor {
        public ArgProcessor(CompilerOptions options) {
            super(options);
            this.registerHandler(new ArgHandlerLocalWorkers(options));
            this.registerHandler(new ArgHandlerWorkDirOptional(options));
            this.registerHandler(new ArgHandlerIncrementalCompile(options));
            this.registerHandler(new ArgHandlerWarDir(options));
            this.registerHandler(new ArgHandlerDeployDir(options));
            this.registerHandler(new ArgHandlerExtraDir(options));
            this.registerHandler(new ArgHandlerSaveSourceOutput(options));
        }

        @Override
        protected String getName() {
            return Compiler.class.getName();
        }
    }
}

