/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.BootStrapPlatform;
import com.google.gwt.dev.CompileTaskOptions;
import com.google.gwt.dev.javac.CompilationProblemReporter;
import com.google.gwt.dev.util.log.PrintWriterTreeLogger;

public class CompileTaskRunner {
    public static boolean runWithAppropriateLogger(CompileTaskOptions options, CompileTask task) {
        BootStrapPlatform.applyPlatformHacks();
        if (System.getProperty("java.awt.headless") == null) {
            System.setProperty("java.awt.headless", "true");
        }
        PrintWriterTreeLogger logger = new PrintWriterTreeLogger();
        logger.setMaxDetail(options.getLogLevel());
        return CompileTaskRunner.doRun(logger, task);
    }

    private static boolean doRun(TreeLogger logger, CompileTask task) {
        try {
            return task.run(logger);
        }
        catch (UnableToCompleteException unableToCompleteException) {
        }
        catch (Throwable e) {
            CompilationProblemReporter.logAndTranslateException(logger, e);
        }
        return false;
    }

    private static void waitForThreadToTerminate(Thread godot) {
        boolean isInterrupted = false;
        while (true) {
            try {
                godot.join();
                return;
            }
            catch (InterruptedException e) {
                isInterrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (isInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static interface CompileTask {
        public boolean run(TreeLogger var1) throws UnableToCompleteException;
    }
}

