/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.CompileTaskOptions;
import com.google.gwt.dev.cfg.Properties;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

class CompileTaskOptionsImpl
implements CompileTaskOptions {
    private Properties finalProperties;
    private TreeLogger.Type logLevel;
    private final List<String> moduleNames = new ArrayList<String>();
    private File workDir;

    @Override
    public void addModuleName(String moduleName) {
        this.moduleNames.add(moduleName);
    }

    public void copyFrom(CompileTaskOptions other) {
        this.setLogLevel(other.getLogLevel());
        this.setModuleNames(other.getModuleNames());
        this.setWorkDir(other.getWorkDir());
        this.setFinalProperties(other.getFinalProperties());
    }

    public File getCompilerWorkDir(String moduleName) {
        return new File(new File(this.getWorkDir(), moduleName), "compiler");
    }

    @Override
    public Properties getFinalProperties() {
        return this.finalProperties;
    }

    @Override
    public TreeLogger.Type getLogLevel() {
        return this.logLevel;
    }

    @Override
    public List<String> getModuleNames() {
        return new ArrayList<String>(this.moduleNames);
    }

    @Override
    public File getWorkDir() {
        return this.workDir;
    }

    @Override
    public void setFinalProperties(Properties finalProperties) {
        this.finalProperties = finalProperties;
    }

    @Override
    public void setLogLevel(TreeLogger.Type logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public void setModuleNames(List<String> moduleNames) {
        this.moduleNames.clear();
        this.moduleNames.addAll(moduleNames);
    }

    @Override
    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }
}

