/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.ArgProcessorBase;
import com.google.gwt.dev.CompilePerms;
import com.google.gwt.dev.CompilerContext;
import com.google.gwt.dev.Permutation;
import com.google.gwt.dev.jjs.PermutationResult;
import com.google.gwt.dev.jjs.UnifiedAst;
import com.google.gwt.dev.util.PerfCounter;
import com.google.gwt.dev.util.PersistenceBackedObject;
import com.google.gwt.dev.util.StringInterningObjectInputStream;
import com.google.gwt.dev.util.arg.ArgHandlerLogLevel;
import com.google.gwt.dev.util.arg.OptionLogLevel;
import com.google.gwt.dev.util.log.PrintWriterTreeLogger;
import com.google.gwt.util.tools.ArgHandlerString;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.UnknownHostException;

public class CompilePermsServer {
    public static void main(String[] args) {
        int exitCode = -1;
        CompileServerOptionsImpl options = new CompileServerOptionsImpl();
        if (new ArgProcessor(options).processArgs(args)) {
            PrintWriterTreeLogger logger = new PrintWriterTreeLogger();
            logger.setMaxDetail(options.getLogLevel());
            if (CompilePermsServer.run(options, logger)) {
                exitCode = 0;
            }
        }
        PerfCounter.print();
        System.exit(exitCode);
    }

    public static boolean run(CompileServerOptions options, TreeLogger logger) {
        try {
            Socket s = new Socket(options.getCompileHost(), options.getCompilePort());
            logger.log(TreeLogger.DEBUG, "Socket opened");
            ObjectOutputStream out = new ObjectOutputStream(s.getOutputStream());
            StringInterningObjectInputStream in = new StringInterningObjectInputStream(s.getInputStream());
            out.writeUTF(options.getCookie());
            out.flush();
            File astFile = (File)in.readObject();
            StringInterningObjectInputStream astIn = new StringInterningObjectInputStream(new FileInputStream(astFile));
            UnifiedAst ast = (UnifiedAst)astIn.readObject();
            ast.prepare();
            logger.log(TreeLogger.SPAM, "Created new UnifiedAst instance");
            long estimatedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            out.writeLong(estimatedMemory);
            out.flush();
            boolean keepGoing = in.readBoolean();
            while (keepGoing) {
                CompilePermsServer.compilePermutation(logger, ast, in, out);
                keepGoing = in.readBoolean();
                if (!logger.isLoggable(TreeLogger.SPAM)) continue;
                logger.log(TreeLogger.SPAM, "keepGoing = " + keepGoing);
            }
            logger.log(TreeLogger.DEBUG, "Successfully terminating");
            return true;
        }
        catch (UnknownHostException e) {
            logger.log(TreeLogger.ERROR, "Invalid hostname", e);
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "Communication error", e);
        }
        catch (ClassNotFoundException e) {
            logger.log(TreeLogger.ERROR, "Probable client/server mismatch or classpath misconfiguration", e);
        }
        return false;
    }

    static void compilePermutation(TreeLogger logger, UnifiedAst ast, ObjectInputStream in, ObjectOutputStream out) throws ClassNotFoundException, IOException {
        PersistenceBackedObject resultFile = (PersistenceBackedObject)in.readObject();
        Permutation permutation = (Permutation)in.readObject();
        logger.log(TreeLogger.SPAM, "Permutation read");
        Throwable caught = null;
        try {
            TreeLogger branch = logger.branch(TreeLogger.DEBUG, "Compiling");
            CompilerContext compilerContext = new CompilerContext.Builder().options(ast.getOptions()).build();
            PermutationResult result = CompilePerms.compile(branch, compilerContext, permutation, ast);
            resultFile.set(logger, result);
            logger.log(TreeLogger.DEBUG, "Successfully compiled permutation");
        }
        catch (UnableToCompleteException e) {
            caught = e;
        }
        catch (Throwable e) {
            logger.log(TreeLogger.ERROR, "Compile failed", e);
            caught = e;
        }
        out.writeObject(caught);
        out.flush();
        logger.log(TreeLogger.SPAM, "Sent result");
    }

    static class CompileServerOptionsImpl
    implements CompileServerOptions {
        private String compileHost;
        private int compilePort;
        private String cookie;
        private TreeLogger.Type logLevel;

        CompileServerOptionsImpl() {
        }

        @Override
        public String getCompileHost() {
            return this.compileHost;
        }

        @Override
        public int getCompilePort() {
            return this.compilePort;
        }

        @Override
        public String getCookie() {
            return this.cookie;
        }

        @Override
        public TreeLogger.Type getLogLevel() {
            return this.logLevel;
        }

        @Override
        public void setCompileHost(String host) {
            assert (host != null);
            this.compileHost = host;
        }

        @Override
        public void setCompilePort(int port) {
            assert (port > 0);
            this.compilePort = port;
        }

        @Override
        public void setCookie(String cookie) {
            this.cookie = cookie;
        }

        @Override
        public void setLogLevel(TreeLogger.Type logLevel) {
            this.logLevel = logLevel;
        }
    }

    static class ArgProcessor
    extends ArgProcessorBase {
        public ArgProcessor(CompileServerOptions options) {
            this.registerHandler(new ArgHandlerLogLevel(options));
            this.registerHandler(new ArgHandlerCompileHost(options));
            this.registerHandler(new ArgHandlerCompilePort(options));
            this.registerHandler(new ArgHandlerCookie(options));
        }

        @Override
        protected String getName() {
            return CompilePermsServer.class.getName();
        }
    }

    static final class ArgHandlerCookie
    extends ArgHandlerString {
        private final CompileServerOptions options;

        public ArgHandlerCookie(CompileServerOptions option) {
            this.options = option;
        }

        @Override
        public String getPurpose() {
            return "Specifies the security cookie the server expects";
        }

        @Override
        public String getTag() {
            return "-cookie";
        }

        @Override
        public String[] getTagArgs() {
            return new String[]{"cookie"};
        }

        @Override
        public boolean isRequired() {
            return true;
        }

        @Override
        public boolean setString(String str) {
            this.options.setCookie(str);
            return true;
        }
    }

    static final class ArgHandlerCompilePort
    extends ArgHandlerString {
        private final CompileServerOptions options;

        public ArgHandlerCompilePort(CompileServerOptions options) {
            this.options = options;
        }

        @Override
        public String getPurpose() {
            return "The port to which the permutation server should connect";
        }

        @Override
        public String getTag() {
            return "-port";
        }

        @Override
        public String[] getTagArgs() {
            return new String[]{"1234"};
        }

        @Override
        public boolean isRequired() {
            return true;
        }

        @Override
        public boolean setString(String str) {
            Integer port = Integer.parseInt(str);
            if (port <= 0) {
                return false;
            }
            this.options.setCompilePort(port);
            return true;
        }
    }

    static final class ArgHandlerCompileHost
    extends ArgHandlerString {
        private final CompileServerOptions options;

        public ArgHandlerCompileHost(CompileServerOptions options) {
            this.options = options;
        }

        @Override
        public String getPurpose() {
            return "The host to which the permutation server should connect";
        }

        @Override
        public String getTag() {
            return "-host";
        }

        @Override
        public String[] getTagArgs() {
            return new String[]{"hostname"};
        }

        @Override
        public boolean isRequired() {
            return true;
        }

        @Override
        public boolean setString(String str) {
            this.options.setCompileHost(str);
            return true;
        }
    }

    public static interface CompileServerOptions
    extends OptionLogLevel {
        public String getCompileHost();

        public int getCompilePort();

        public String getCookie();

        public void setCompileHost(String var1);

        public void setCompilePort(int var1);

        public void setCookie(String var1);
    }
}

