/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.CompileTaskRunner;
import com.google.gwt.dev.CompilerContext;
import com.google.gwt.dev.Link;
import com.google.gwt.dev.Permutation;
import com.google.gwt.dev.PermutationWorkerFactory;
import com.google.gwt.dev.Precompilation;
import com.google.gwt.dev.PrecompilationResult;
import com.google.gwt.dev.Precompile;
import com.google.gwt.dev.PrecompileTaskArgProcessor;
import com.google.gwt.dev.PrecompileTaskOptions;
import com.google.gwt.dev.PrecompileTaskOptionsImpl;
import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.dev.cfg.ModuleDefLoader;
import com.google.gwt.dev.cfg.PropertyCombinations;
import com.google.gwt.dev.jjs.JavaToJavaScriptCompiler;
import com.google.gwt.dev.jjs.PermutationResult;
import com.google.gwt.dev.jjs.UnifiedAst;
import com.google.gwt.dev.util.FileBackedObject;
import com.google.gwt.dev.util.MemoryBackedObject;
import com.google.gwt.dev.util.PerfCounter;
import com.google.gwt.dev.util.PersistenceBackedObject;
import com.google.gwt.dev.util.Util;
import com.google.gwt.dev.util.arg.ArgHandlerLocalWorkers;
import com.google.gwt.dev.util.arg.OptionLocalWorkers;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.util.tools.ArgHandlerString;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class CompilePerms {
    private CompilerContext compilerContext;
    private CompilerContext.Builder compilerContextBuilder;
    private final CompilePermsOptionsImpl options;

    public static PermutationResult compile(TreeLogger logger, CompilerContext compilerContext, Permutation permutation, UnifiedAst unifiedAst) throws UnableToCompleteException {
        return JavaToJavaScriptCompiler.compilePermutation(unifiedAst, logger, compilerContext, permutation);
    }

    public static void compile(TreeLogger logger, CompilerContext compilerContext, Precompilation precompilation, Permutation[] perms, int localWorkers, List<PersistenceBackedObject<PermutationResult>> resultFiles) throws UnableToCompleteException {
        TreeLogger branch = logger.branch(TreeLogger.INFO, "Compiling " + perms.length + " permutation" + (perms.length > 1 ? "s" : ""));
        PermutationWorkerFactory.compilePermutations(branch, compilerContext, precompilation, perms, localWorkers, resultFiles);
        logger.log(TreeLogger.INFO, "Compile of permutations succeeded");
    }

    public static void main(String[] args) {
        CompileTaskRunner.CompileTask task;
        int exitCode = -1;
        final CompilePermsOptionsImpl options = new CompilePermsOptionsImpl();
        if (new ArgProcessor(options).processArgs(args) && CompileTaskRunner.runWithAppropriateLogger(options, task = new CompileTaskRunner.CompileTask(){

            @Override
            public boolean run(TreeLogger logger) throws UnableToCompleteException {
                return new CompilePerms(options).run(logger);
            }
        })) {
            exitCode = 0;
        }
        PerfCounter.print();
        System.exit(exitCode);
    }

    public static List<PersistenceBackedObject<PermutationResult>> makeResultFiles(File compilerWorkDir, Permutation[] perms, PrecompileTaskOptions options) {
        ArrayList<PersistenceBackedObject<PermutationResult>> toReturn = Lists.newArrayList();
        for (int i = 0; i < perms.length; ++i) {
            if (options.isIncrementalCompileEnabled()) {
                toReturn.add(new MemoryBackedObject<PermutationResult>(PermutationResult.class));
                continue;
            }
            File f = CompilePerms.makePermFilename(compilerWorkDir, perms[i].getId());
            toReturn.add(new FileBackedObject<PermutationResult>(PermutationResult.class, f));
        }
        return toReturn;
    }

    static File makePermFilename(File compilerWorkDir, int permNumber) {
        return new File(compilerWorkDir, "permutation-" + permNumber + ".js");
    }

    static PrecompilationResult readPrecompilationFile(TreeLogger logger, File precompilationFile) {
        PrecompilationResult precompileResults = null;
        try {
            precompileResults = Util.readFileAsObject(precompilationFile, PrecompilationResult.class);
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "Failed to read " + precompilationFile + "\nHas Precompile been run?");
        }
        catch (ClassNotFoundException e) {
            logger.log(TreeLogger.ERROR, "Failed to read " + precompilationFile, e);
        }
        return precompileResults;
    }

    static Permutation[] selectPermutationsForPrecompilation(int[] permsToRun, Precompilation precompilation) {
        if (permsToRun == null) {
            return precompilation.getPermutations();
        }
        ArrayList<Permutation> subPermsList = new ArrayList<Permutation>();
        for (int id : permsToRun) {
            for (Permutation perm : precompilation.getPermutations()) {
                if (perm.getId() != id) continue;
                subPermsList.add(perm);
            }
        }
        return subPermsList.toArray(new Permutation[subPermsList.size()]);
    }

    public CompilePerms(CompilePermsOptions options) {
        this.options = new CompilePermsOptionsImpl(options);
        this.compilerContextBuilder = new CompilerContext.Builder();
    }

    public boolean run(TreeLogger logger) throws UnableToCompleteException {
        for (String moduleName : this.options.getModuleNames()) {
            int[] permsToRun = this.options.getPermsToCompile();
            File compilerWorkDir = this.options.getCompilerWorkDir(moduleName);
            File precompilationFile = new File(compilerWorkDir, "precompilation.ser");
            PrecompilationResult precompileResults = CompilePerms.readPrecompilationFile(logger, precompilationFile);
            if (precompileResults instanceof PrecompileTaskOptions) {
                PrecompileTaskOptions precompilationOptions = (PrecompileTaskOptions)precompileResults;
                if (this.precompileAndCompile(logger, moduleName, compilerWorkDir, precompilationOptions)) continue;
                return false;
            }
            ModuleDef module = ModuleDefLoader.loadFromClassPath(logger, moduleName);
            this.compilerContext = this.compilerContextBuilder.options(this.options).module(module).build();
            Precompilation precompilation = (Precompilation)precompileResults;
            Permutation[] subPerms = CompilePerms.selectPermutationsForPrecompilation(permsToRun, precompilation);
            List<PersistenceBackedObject<PermutationResult>> resultFiles = CompilePerms.makeResultFiles(compilerWorkDir, subPerms, this.options);
            CompilePerms.compile(logger, this.compilerContext, precompilation, subPerms, this.options.getLocalWorkers(), resultFiles);
        }
        return true;
    }

    private boolean precompileAndCompile(TreeLogger logger, String moduleName, File compilerWorkDir, PrecompileTaskOptions precompilationOptions) throws UnableToCompleteException {
        precompilationOptions.setGenDir(null);
        ModuleDef module = ModuleDefLoader.loadFromClassPath(logger, moduleName);
        this.compilerContext = this.compilerContextBuilder.options(precompilationOptions).module(module).build();
        PropertyCombinations allPermutations = new PropertyCombinations(module.getProperties(), module.getActiveLinkerNames());
        List<PropertyCombinations> collapsedPermutations = allPermutations.collapseProperties();
        int[] perms = this.options.getPermsToCompile();
        if (perms == null) {
            perms = new int[collapsedPermutations.size()];
            for (int i = 0; i < perms.length; ++i) {
                perms[i] = i;
            }
        }
        logger = logger.branch(TreeLogger.INFO, "Compiling " + perms.length + " permutation" + (perms.length > 1 ? "s" : ""));
        for (int permId : perms) {
            PropertyCombinations onePerm = collapsedPermutations.get(permId);
            Precompilation precompilation = Precompile.precompile(logger, this.compilerContext, permId, onePerm);
            if (precompilation == null) {
                return false;
            }
            boolean embedSourcesContent = this.compilerContext.getModule().shouldEmbedSourceMapContents();
            if (!this.options.shouldSaveSource() && !embedSourcesContent) {
                precompilation.removeSourceArtifacts(logger);
            }
            Permutation[] subPerms = CompilePerms.selectPermutationsForPrecompilation(new int[]{permId}, precompilation);
            assert (subPerms.length == 1);
            PermutationResult permResult = CompilePerms.compile(logger, this.compilerContext, subPerms[0], precompilation.getUnifiedAst());
            Link.linkOnePermutationToJar(logger, this.compilerContext.getModule(), this.compilerContext.getPublicResourceOracle(), precompilation.getGeneratedArtifacts(), permResult, CompilePerms.makePermFilename(compilerWorkDir, permId), this.compilerContext.getOptions());
        }
        logger.log(TreeLogger.INFO, "Compile of permutations succeeded");
        return true;
    }

    static class CompilePermsOptionsImpl
    extends PrecompileTaskOptionsImpl
    implements CompilePermsOptions {
        private int localWorkers;
        private int[] permsToCompile;

        public CompilePermsOptionsImpl() {
        }

        public CompilePermsOptionsImpl(CompilePermsOptions other) {
            this.copyFrom(other);
        }

        public void copyFrom(CompilePermsOptions other) {
            super.copyFrom(other);
            this.setPermsToCompile(other.getPermsToCompile());
            this.setLocalWorkers(other.getLocalWorkers());
        }

        @Override
        public int getLocalWorkers() {
            return this.localWorkers;
        }

        @Override
        public int[] getPermsToCompile() {
            return this.permsToCompile == null ? null : (int[])this.permsToCompile.clone();
        }

        @Override
        public void setLocalWorkers(int localWorkers) {
            this.localWorkers = localWorkers;
        }

        @Override
        public void setPermsToCompile(int[] permsToCompile) {
            this.permsToCompile = permsToCompile == null ? null : (int[])permsToCompile.clone();
        }
    }

    static class ArgProcessor
    extends PrecompileTaskArgProcessor {
        public ArgProcessor(CompilePermsOptions options) {
            super(options);
            this.registerHandler(new ArgHandlerPerms(options));
            this.registerHandler(new ArgHandlerLocalWorkers(options));
        }

        @Override
        protected String getName() {
            return CompilePerms.class.getName();
        }
    }

    protected static final class ArgHandlerPerms
    extends ArgHandlerString {
        private final OptionPerms option;

        public ArgHandlerPerms(OptionPerms option) {
            this.option = option;
        }

        @Override
        public String getPurpose() {
            return "Comma-delimited list of 0-based permutations to compile";
        }

        @Override
        public String getTag() {
            return "-perms";
        }

        @Override
        public String[] getTagArgs() {
            return new String[]{"permlist"};
        }

        @Override
        public boolean setString(String str) {
            String[] split = str.split(",");
            if (split.length < 1) {
                System.err.println(this.getTag() + " requires a comma-delimited list of integers");
                return false;
            }
            TreeSet<Integer> permSet = new TreeSet<Integer>();
            for (String item : split) {
                try {
                    int value = Integer.parseInt(item);
                    if (value < 0) {
                        System.err.println(this.getTag() + " error: negative value '" + value + "' is not allowed");
                        return false;
                    }
                    permSet.add(value);
                }
                catch (NumberFormatException e) {
                    System.err.println(this.getTag() + " requires a comma-delimited list of integers; '" + item + "' is not an integer");
                    return false;
                }
            }
            int[] permsToCompile = new int[permSet.size()];
            int i = 0;
            Iterator iterator = permSet.iterator();
            while (iterator.hasNext()) {
                int perm = (Integer)iterator.next();
                permsToCompile[i++] = perm;
            }
            this.option.setPermsToCompile(permsToCompile);
            return true;
        }
    }

    public static interface OptionPerms {
        public int[] getPermsToCompile();

        public void setPermsToCompile(int[] var1);
    }

    public static interface CompilePermsOptions
    extends PrecompileTaskOptions,
    OptionLocalWorkers,
    OptionPerms {
    }
}

