/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.util.Locale;

public class BootStrapPlatform {
    public static void applyPlatformHacks() {
        if (BootStrapPlatform.isMac()) {
            BootStrapPlatform.setSystemProperties();
            BootStrapPlatform.fixContextClassLoaderOnMainThread();
        }
    }

    public static void initGui() {
        if (BootStrapPlatform.isMac() && !GraphicsEnvironment.isHeadless()) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Development Mode");
            GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            Toolkit.getDefaultToolkit();
        }
    }

    public static void initHostedMode() {
    }

    public static boolean isMac() {
        String lcOSName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        return lcOSName.startsWith("mac ");
    }

    private static void fixContextClassLoaderOnMainThread() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            Thread.currentThread().setContextClassLoader(BootStrapPlatform.class.getClassLoader());
        }
    }

    private static void setSystemProperties() {
        System.setProperty("com.apple.eawt.CocoaComponent.CompatibilityMode", "false");
    }
}

