/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.CompileTaskRunner;
import com.google.gwt.dev.PrecompileTaskArgProcessor;
import com.google.gwt.dev.PrecompileTaskOptions;
import com.google.gwt.dev.PrecompileTaskOptionsImpl;
import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.dev.cfg.ModuleDefLoader;
import com.google.gwt.dev.cfg.PropertyCombinations;
import com.google.gwt.dev.util.Memory;
import com.google.gwt.dev.util.Util;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import java.io.File;
import java.io.IOException;

public class AnalyzeModule {
    static final String OPTIONS_FILENAME = "compilerOptions.ser";
    static final String PERM_COUNT_FILENAME = "permCount.txt";
    private final AnalyzeModuleOptionsImpl options;

    public static void main(String[] args) {
        Memory.initialize();
        SpeedTracerLogger.init();
        SpeedTracerLogger.Event analyzeModuleEvent = SpeedTracerLogger.start(CompilerEventType.ANALYZE_MODULE, new String[0]);
        final AnalyzeModuleOptionsImpl options = new AnalyzeModuleOptionsImpl();
        if (new ArgProcessor(options).processArgs(args)) {
            CompileTaskRunner.CompileTask task = new CompileTaskRunner.CompileTask(){

                @Override
                public boolean run(TreeLogger logger) throws UnableToCompleteException {
                    return new AnalyzeModule(options).run(logger);
                }
            };
            CompileTaskRunner.runWithAppropriateLogger(options, task);
        }
        analyzeModuleEvent.end(new String[0]);
    }

    public static PrecompileTaskOptions readAnalyzeModuleOptionsFile(TreeLogger logger, File compilerWorkDir) {
        File optionsFile = new File(compilerWorkDir, OPTIONS_FILENAME);
        PrecompileTaskOptions precompilationOptions = null;
        try {
            precompilationOptions = Util.readFileAsObject(optionsFile, PrecompileTaskOptions.class);
        }
        catch (IOException e) {
            if (logger.isLoggable(TreeLogger.DEBUG)) {
                logger.log(TreeLogger.DEBUG, "Failed to read " + optionsFile + "\nHas AnalyzeModule been run?  Falling back.", e);
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            logger.log(TreeLogger.ERROR, "Failed to read " + optionsFile, e);
            return null;
        }
        return precompilationOptions;
    }

    public AnalyzeModule(AnalyzeModuleOptions options) {
        this.options = new AnalyzeModuleOptionsImpl(options);
    }

    public boolean run(TreeLogger logger) throws UnableToCompleteException {
        for (String moduleName : this.options.getModuleNames()) {
            File compilerWorkDir = this.options.getCompilerWorkDir(moduleName);
            Util.recursiveDelete(compilerWorkDir, true);
            compilerWorkDir.mkdirs();
            ModuleDef module = ModuleDefLoader.loadFromClassPath(logger, moduleName);
            if (logger.isLoggable(TreeLogger.INFO)) {
                logger.log(TreeLogger.INFO, "Analyzing module " + module.getName());
            }
            int numPermutations = new PropertyCombinations(module.getProperties(), module.getActiveLinkerNames()).collapseProperties().size();
            Util.writeStringAsFile(logger, new File(compilerWorkDir, PERM_COUNT_FILENAME), String.valueOf(numPermutations));
            Util.writeObjectAsFile(logger, new File(compilerWorkDir, OPTIONS_FILENAME), this.options);
        }
        return true;
    }

    private static interface AnalyzeModuleOptions
    extends PrecompileTaskOptions {
    }

    static class ArgProcessor
    extends PrecompileTaskArgProcessor {
        public ArgProcessor(AnalyzeModuleOptions options) {
            super(options);
        }

        @Override
        protected String getName() {
            return AnalyzeModule.class.getName();
        }
    }

    static class AnalyzeModuleOptionsImpl
    extends PrecompileTaskOptionsImpl
    implements AnalyzeModuleOptions {
        public AnalyzeModuleOptionsImpl() {
        }

        public AnalyzeModuleOptionsImpl(AnalyzeModuleOptions other) {
            this.copyFrom(other);
        }

        public void copyFrom(AnalyzeModuleOptions other) {
            super.copyFrom(other);
        }
    }
}

