/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.linker;

import com.google.gwt.core.ext.LinkerContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.AbstractLinker;
import com.google.gwt.core.ext.linker.Artifact;
import com.google.gwt.core.ext.linker.ArtifactSet;
import com.google.gwt.core.ext.linker.CompilationResult;
import com.google.gwt.core.ext.linker.EmittedArtifact;
import com.google.gwt.core.ext.linker.LinkerOrder;
import com.google.gwt.core.ext.linker.SelectionProperty;
import com.google.gwt.core.ext.linker.Shardable;
import com.google.gwt.core.ext.linker.SoftPermutation;
import com.google.gwt.core.ext.linker.SymbolData;
import com.google.gwt.core.ext.linker.SyntheticArtifact;
import com.google.gwt.core.ext.linker.impl.StandardLinkerContext;
import com.google.gwt.dev.cfg.ResourceLoader;
import com.google.gwt.dev.cfg.ResourceLoaders;
import com.google.gwt.dev.util.Util;
import com.google.gwt.dev.util.collect.HashMap;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.debugging.sourcemap.SourceMapConsumerV3;
import com.google.gwt.thirdparty.debugging.sourcemap.SourceMapGeneratorV3;
import com.google.gwt.thirdparty.debugging.sourcemap.SourceMapParseException;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.util.tools.Utility;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.regex.Pattern;

@LinkerOrder(value=LinkerOrder.Order.POST)
@Shardable
public class SymbolMapsLinker
extends AbstractLinker {
    public static final String MAKE_SYMBOL_MAPS = "compiler.useSymbolMaps";
    public static final String STRONG_NAME_SUFFIX = ".symbolMap";

    public static String propertyMapToString(Map<SelectionProperty, String> propertyMap) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        SymbolMapsLinker.printPropertyMap(pw, propertyMap);
        pw.flush();
        return writer.toString();
    }

    private static void printPropertyMap(PrintWriter pw, Map<SelectionProperty, String> map) {
        boolean needsComma = false;
        for (Map.Entry<SelectionProperty, String> entry : map.entrySet()) {
            if (needsComma) {
                pw.print(" , ");
            } else {
                needsComma = true;
            }
            pw.print("'");
            pw.print(entry.getKey().getName());
            pw.print("' : '");
            pw.print(entry.getValue());
            pw.print("'");
        }
    }

    @Override
    public String getDescription() {
        return "Export CompilationResult symbol maps";
    }

    @Override
    public ArtifactSet link(TreeLogger logger, LinkerContext context, ArtifactSet artifacts) throws UnableToCompleteException {
        return this.link(logger, context, artifacts, true);
    }

    @Override
    public ArtifactSet link(TreeLogger logger, LinkerContext context, ArtifactSet artifacts, boolean onePermutation) throws UnableToCompleteException {
        if (onePermutation) {
            artifacts = new ArtifactSet(artifacts);
            HashMap<Integer, String> permMap = new HashMap<Integer, String>();
            SpeedTracerLogger.Event writeSymbolMapsEvent = SpeedTracerLogger.start(CompilerEventType.WRITE_SYMBOL_MAPS, new String[0]);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            for (CompilationResult result : artifacts.find(CompilationResult.class)) {
                boolean makeSymbolMaps = true;
                for (SoftPermutation perm : result.getSoftPermutations()) {
                    for (Map.Entry<SelectionProperty, String> propMapEntry : perm.getPropertyMap().entrySet()) {
                        if (!propMapEntry.getKey().getName().equals(MAKE_SYMBOL_MAPS)) continue;
                        makeSymbolMaps = Boolean.valueOf(propMapEntry.getValue());
                    }
                }
                permMap.put(result.getPermutationId(), result.getStrongName());
                if (!makeSymbolMaps) continue;
                PrintWriter pw = new PrintWriter(out);
                this.doWriteSymbolMap(logger, result, pw);
                pw.close();
                this.doEmitSymbolMap(logger, artifacts, result, out);
                out.reset();
            }
            writeSymbolMapsEvent.end(new String[0]);
            SpeedTracerLogger.Event writeSourceMapsEvent = SpeedTracerLogger.start(CompilerEventType.WRITE_SOURCE_MAPS, new String[0]);
            StandardLinkerContext stdContext = (StandardLinkerContext)context;
            for (SourceMapArtifact se : artifacts.find(SourceMapArtifact.class)) {
                String sourceMapString = Util.readStreamAsString(se.getContents(logger));
                String strongName = (String)permMap.get(se.getPermutationId());
                String partialPath = strongName + "_sourceMap" + se.getFragment() + ".json";
                int fragment = se.getFragment();
                ScriptFragmentEditsArtifact editArtifact = null;
                for (ScriptFragmentEditsArtifact mp : artifacts.find(ScriptFragmentEditsArtifact.class)) {
                    if (!mp.getStrongName().equals(strongName) || mp.getFragment() != fragment) continue;
                    editArtifact = mp;
                    artifacts.remove(editArtifact);
                    break;
                }
                SyntheticArtifact emArt = null;
                if (editArtifact == null) {
                    emArt = this.emitSourceMapString(logger, sourceMapString, partialPath);
                } else {
                    SourceMapGeneratorV3 sourceMapGenerator = new SourceMapGeneratorV3();
                    if (se.getSourceRoot() != null) {
                        sourceMapGenerator.setSourceRoot(se.getSourceRoot());
                    }
                    try {
                        int totalPrefixLines = 0;
                        for (ScriptFragmentEditsArtifact.EditOperation op : editArtifact.editOperations) {
                            if (op.getOp() != ScriptFragmentEditsArtifact.Edit.PREFIX) continue;
                            totalPrefixLines += op.getNumLines();
                        }
                        if (stdContext.getModule().shouldEmbedSourceMapContents()) {
                            SymbolMapsLinker.embedSourcesInSourceMaps(logger, stdContext, artifacts, sourceMapGenerator, totalPrefixLines, sourceMapString, partialPath);
                        } else {
                            sourceMapGenerator.mergeMapSection(totalPrefixLines, 0, sourceMapString, (extKey, oldVal, newVal) -> newVal);
                        }
                        StringWriter stringWriter = new StringWriter();
                        sourceMapGenerator.appendTo(stringWriter, "sourceMap");
                        emArt = this.emitSourceMapString(logger, stringWriter.toString(), partialPath);
                    }
                    catch (Exception e) {
                        logger.log(TreeLogger.Type.WARN, "Can't write source map " + partialPath, e);
                    }
                }
                artifacts.add(emArt);
                artifacts.remove(se);
            }
            writeSourceMapsEvent.end(new String[0]);
        }
        return artifacts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void embedSourcesInSourceMaps(TreeLogger logger, StandardLinkerContext context, ArtifactSet artifacts, SourceMapGeneratorV3 sourceMapGenerator, int totalPrefixLines, String sourceMapString, String partialPath) throws SourceMapParseException {
        sourceMapGenerator.setStartingPosition(totalPrefixLines, 0);
        SourceMapConsumerV3 section = new SourceMapConsumerV3();
        section.parse(sourceMapString);
        section.visitMappings(sourceMapGenerator::addMapping);
        for (Map.Entry<String, Object> entry : section.getExtensions().entrySet()) {
            String extensionKey = entry.getKey();
            sourceMapGenerator.addExtension(extensionKey, entry.getValue());
        }
        ResourceLoader resourceLoader = ResourceLoaders.fromContextClassLoader();
        java.util.HashMap<String, EmittedArtifact> generatedSources = Maps.newHashMap();
        artifacts.find(EmittedArtifact.class).forEach(emittedArtifact -> {
            if (EmittedArtifact.Visibility.Source == emittedArtifact.getVisibility()) {
                generatedSources.put(emittedArtifact.getPartialPath(), (EmittedArtifact)emittedArtifact);
            }
        });
        for (String sourceFileName : section.getOriginalSources()) {
            InputStream cis = null;
            try {
                cis = SymbolMapsLinker.loadSource(logger, sourceFileName, generatedSources, resourceLoader);
                if (Objects.isNull(cis)) {
                    cis = context.getModule().findSourceFile(sourceFileName).openContents();
                }
                String content = Util.readStreamAsString(cis);
                sourceMapGenerator.addSourcesContent(sourceFileName, content);
            }
            catch (UnableToCompleteException | IOException | URISyntaxException e) {
                try {
                    logger.log(TreeLogger.Type.WARN, "Can't write source map " + partialPath, e);
                }
                catch (Throwable throwable) {
                    Utility.close(cis);
                    throw throwable;
                }
                Utility.close(cis);
                continue;
            }
            Utility.close(cis);
        }
    }

    private static InputStream loadSource(TreeLogger logger, String sourceFileName, Map<String, EmittedArtifact> generatedSources, ResourceLoader resourceLoader) throws UnableToCompleteException, URISyntaxException, IOException {
        if (generatedSources.containsKey(sourceFileName)) {
            return generatedSources.get(sourceFileName).getContents(logger);
        }
        URL resource = resourceLoader.getResource(sourceFileName);
        if (Objects.nonNull(resource)) {
            return resource.openStream();
        }
        return null;
    }

    protected void doEmitSymbolMap(TreeLogger logger, ArtifactSet artifacts, CompilationResult result, ByteArrayOutputStream out) throws UnableToCompleteException {
        SyntheticArtifact symbolMapArtifact = this.emitBytes(logger, out.toByteArray(), result.getStrongName() + STRONG_NAME_SUFFIX);
        symbolMapArtifact.setVisibility(EmittedArtifact.Visibility.LegacyDeploy);
        artifacts.add(symbolMapArtifact);
    }

    /*
     * WARNING - void declaration
     */
    protected void doWriteSymbolMap(TreeLogger logger, CompilationResult result, PrintWriter pw) throws UnableToCompleteException {
        pw.println("# { " + result.getPermutationId() + " }");
        for (SortedMap sortedMap : result.getPropertyMap()) {
            pw.print("# { ");
            SymbolMapsLinker.printPropertyMap(pw, sortedMap);
            pw.println(" }");
        }
        pw.println("# jsName, jsniIdent, className, memberName, sourceUri, sourceLine, fragmentNumber");
        StringBuilder sb = new StringBuilder(1024);
        char[] cArray = new char[1024];
        for (SymbolData symbol : result.getSymbolMap()) {
            void var5_7;
            sb.append(symbol.getSymbolName());
            sb.append(',');
            String jsniIdent = symbol.getJsniIdent();
            if (jsniIdent != null) {
                sb.append(jsniIdent);
            }
            sb.append(',');
            sb.append(symbol.getClassName());
            sb.append(',');
            String memberName = symbol.getMemberName();
            if (memberName != null) {
                sb.append(memberName);
            }
            sb.append(',');
            String sourceUri = symbol.getSourceUri();
            if (sourceUri != null) {
                sb.append(sourceUri);
            }
            sb.append(',');
            sb.append(symbol.getSourceLine());
            sb.append(',');
            sb.append(symbol.getFragmentNumber());
            sb.append('\n');
            int sbLen = sb.length();
            if (((void)var5_7).length < sbLen) {
                int bufLen;
                for (bufLen = ((void)var5_7).length; bufLen < sbLen; bufLen <<= 1) {
                }
                char[] cArray2 = new char[bufLen];
            }
            sb.getChars(0, sbLen, (char[])var5_7, 0);
            pw.write((char[])var5_7, 0, sbLen);
            sb.setLength(0);
        }
    }

    protected SyntheticArtifact emitSourceMapString(TreeLogger logger, String contents, String partialPath) throws UnableToCompleteException {
        SyntheticArtifact emArt = this.emitString(logger, contents, partialPath);
        emArt.setVisibility(EmittedArtifact.Visibility.LegacyDeploy);
        return emArt;
    }

    public static class SourceMapArtifact
    extends SyntheticArtifact {
        public static final Pattern isSourceMapFile = Pattern.compile("sourceMap[0-9]+\\.json$");
        private int permutationId;
        private int fragment;
        private byte[] js;
        private final String sourceRoot;

        public SourceMapArtifact(int permutationId, int fragment, byte[] js, String sourceRoot) {
            super(SymbolMapsLinker.class, permutationId + 47 + SourceMapArtifact.sourceMapFilenameForFragment(fragment), js);
            this.permutationId = permutationId;
            this.fragment = fragment;
            this.js = js;
            this.sourceRoot = sourceRoot;
        }

        public int getFragment() {
            return this.fragment;
        }

        public int getPermutationId() {
            return this.permutationId;
        }

        public String getSourceRoot() {
            return this.sourceRoot;
        }

        public static String sourceMapFilenameForFragment(int fragment) {
            return "sourceMap" + fragment + ".json";
        }
    }

    public static class ScriptFragmentEditsArtifact
    extends Artifact<ScriptFragmentEditsArtifact> {
        private List<EditOperation> editOperations = new ArrayList<EditOperation>();
        private String strongName;
        private int fragment;

        public ScriptFragmentEditsArtifact(String strongName, int fragment) {
            super(SymbolMapsLinker.class);
            this.strongName = strongName;
            this.fragment = fragment;
        }

        public int getFragment() {
            return this.fragment;
        }

        public String getStrongName() {
            return this.strongName;
        }

        @Override
        public int hashCode() {
            return (this.strongName + this.fragment).hashCode();
        }

        public void prefixLines(String lines) {
            this.editOperations.add(EditOperation.prefix(lines));
        }

        @Override
        protected int compareToComparableArtifact(ScriptFragmentEditsArtifact o) {
            int result = (this.strongName + this.fragment).compareTo(this.strongName + this.fragment);
            return result;
        }

        @Override
        protected Class<ScriptFragmentEditsArtifact> getComparableArtifactType() {
            return ScriptFragmentEditsArtifact.class;
        }

        private static class EditOperation {
            Edit op;
            int numLines;

            public static EditOperation prefix(String data) {
                return new EditOperation(Edit.PREFIX, 0, data);
            }

            public EditOperation(Edit op, int lineNumber, String data) {
                this.op = op;
                this.numLines = this.countNewLines(data);
            }

            public int getNumLines() {
                return this.numLines;
            }

            public Edit getOp() {
                return this.op;
            }

            private int countNewLines(String chunkJs) {
                int newLineCount = 0;
                for (int j = 0; j < chunkJs.length(); ++j) {
                    if (chunkJs.charAt(j) != '\n') continue;
                    ++newLineCount;
                }
                return newLineCount;
            }
        }

        public static enum Edit {
            PREFIX,
            INSERT,
            REMOVE;

        }
    }
}

