/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.linker;

import com.google.gwt.core.ext.Linker;
import com.google.gwt.core.ext.LinkerContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.linker.Artifact;
import com.google.gwt.core.ext.linker.ArtifactSet;
import com.google.gwt.core.ext.linker.CompilationResult;
import com.google.gwt.core.ext.linker.EmittedArtifact;
import com.google.gwt.core.ext.linker.LinkerOrder;
import com.google.gwt.core.ext.linker.ModuleMetricsArtifact;
import com.google.gwt.core.ext.linker.Shardable;
import com.google.gwt.core.ext.linker.SyntheticArtifact;
import com.google.gwt.core.ext.linker.Transferable;
import com.google.gwt.core.linker.SymbolMapsLinker;
import com.google.gwt.soyc.CompilerMetricsXmlFormatter;
import com.google.gwt.soyc.SoycDashboard;
import com.google.gwt.soyc.io.ArtifactsOutputDirectory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;

@LinkerOrder(value=LinkerOrder.Order.POST)
@Shardable
public class SoycReportLinker
extends Linker {
    @Override
    public String getDescription() {
        return "Emit compile report artifacts";
    }

    @Override
    public ArtifactSet link(TreeLogger logger, LinkerContext context, ArtifactSet artifacts, boolean onePermutation) {
        boolean reportFilesPresent = this.anyReportFilesPresent(artifacts);
        boolean metricsPresent = this.anyCompilerMetricsPresent(artifacts);
        if (!reportFilesPresent && !metricsPresent) {
            return artifacts;
        }
        artifacts = new ArtifactSet(artifacts);
        if (!onePermutation) {
            this.buildCompilerMetricsXml(artifacts);
        }
        if (reportFilesPresent) {
            if (onePermutation) {
                this.emitPermutationDescriptions(artifacts);
            } else {
                this.buildTopLevelFiles(logger, artifacts);
            }
        }
        return artifacts;
    }

    boolean anyCompilerMetricsPresent(ArtifactSet artifacts) {
        return !artifacts.find(ModuleMetricsArtifact.class).isEmpty();
    }

    boolean anyReportFilesPresent(ArtifactSet artifacts) {
        String prefix1 = "compile-report/";
        String prefix2 = "soycReport/" + prefix1;
        for (EmittedArtifact art : artifacts.find(EmittedArtifact.class)) {
            if (art.getPartialPath().startsWith(prefix1)) {
                return true;
            }
            if (!art.getPartialPath().startsWith(prefix2)) continue;
            return true;
        }
        return false;
    }

    private void buildCompilerMetricsXml(ArtifactSet artifacts) {
        Iterator iterator;
        ModuleMetricsArtifact moduleMetrics = null;
        SortedSet<ModuleMetricsArtifact> moduleMetricsSet = artifacts.find(ModuleMetricsArtifact.class);
        if (!moduleMetricsSet.isEmpty() && (iterator = moduleMetricsSet.iterator()).hasNext()) {
            ModuleMetricsArtifact metrics;
            moduleMetrics = metrics = (ModuleMetricsArtifact)iterator.next();
        }
        if (moduleMetrics == null) {
            return;
        }
        byte[] xmlResult = CompilerMetricsXmlFormatter.writeMetricsAsXml(artifacts, moduleMetrics);
        SyntheticArtifact metricsArtifact = new SyntheticArtifact(SoycReportLinker.class, "compilerMetrics.xml", xmlResult);
        metricsArtifact.setVisibility(EmittedArtifact.Visibility.Private);
        artifacts.add(metricsArtifact);
    }

    private void buildTopLevelFiles(TreeLogger logger, ArtifactSet artifacts) {
        ArtifactsOutputDirectory out = new ArtifactsOutputDirectory();
        try {
            new SoycDashboard(out).generateCrossPermutationFiles(this.extractPermutationDescriptions(artifacts));
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "Error while generating a Story of Your Compile", e);
            e.printStackTrace();
        }
        artifacts.addAll((Collection<? extends Artifact<?>>)out.getArtifacts());
    }

    private void emitPermutationDescriptions(ArtifactSet artifacts) {
        for (CompilationResult res : artifacts.find(CompilationResult.class)) {
            int permId = res.getPermutationId();
            ArrayList<String> permDesc = new ArrayList<String>();
            for (Map map : res.getPropertyMap()) {
                permDesc.add(SymbolMapsLinker.propertyMapToString(map));
            }
            artifacts.add(new PermDescriptionArtifact(permId, permDesc));
        }
    }

    private Map<String, List<String>> extractPermutationDescriptions(ArtifactSet artifacts) {
        TreeMap<String, List<String>> permDescriptions = new TreeMap<String, List<String>>();
        for (PermDescriptionArtifact art : artifacts.find(PermDescriptionArtifact.class)) {
            permDescriptions.put(Integer.toString(art.getPermId()), art.getPermDesc());
        }
        return permDescriptions;
    }

    @Transferable
    private static class PermDescriptionArtifact
    extends Artifact<PermDescriptionArtifact> {
        private List<String> permDesc;
        private int permId;

        public PermDescriptionArtifact(int permId, List<String> permDesc) {
            super(SoycReportLinker.class);
            this.permId = permId;
            this.permDesc = permDesc;
        }

        public List<String> getPermDesc() {
            return this.permDesc;
        }

        public int getPermId() {
            return this.permId;
        }

        @Override
        public int hashCode() {
            return this.permId;
        }

        @Override
        protected int compareToComparableArtifact(PermDescriptionArtifact o) {
            int cmp = this.permId - o.getPermId();
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.permDesc.size() - o.getPermDesc().size();
            if (cmp != 0) {
                return cmp;
            }
            for (int i = 0; i < this.permDesc.size(); ++i) {
                cmp = this.permDesc.get(i).compareTo(o.getPermDesc().get(i));
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }

        @Override
        protected Class<PermDescriptionArtifact> getComparableArtifactType() {
            return PermDescriptionArtifact.class;
        }
    }
}

