/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.typeinfo;

import com.google.gwt.core.ext.typeinfo.JAnnotationType;
import com.google.gwt.core.ext.typeinfo.JArrayType;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JEnumType;
import com.google.gwt.core.ext.typeinfo.JGenericType;
import com.google.gwt.core.ext.typeinfo.JParameterizedType;
import com.google.gwt.core.ext.typeinfo.JRawType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.JTypeParameter;
import com.google.gwt.core.ext.typeinfo.JWildcardType;
import java.util.HashMap;
import java.util.Map;

public enum JPrimitiveType implements JType
{
    BOOLEAN("boolean", "Boolean", 'Z', "false"),
    BYTE("byte", "Byte", 'B', "0"),
    CHAR("char", "Character", 'C', "0"),
    DOUBLE("double", "Double", 'D', "0d"),
    FLOAT("float", "Float", 'F', "0f"),
    INT("int", "Integer", 'I', "0"),
    LONG("long", "Long", 'J', "0L"),
    SHORT("short", "Short", 'S', "0"),
    VOID("void", "Void", 'V', "null");

    private final String boxedName;
    private final String defaultValue;
    private final String jni;
    private final String name;

    public static JPrimitiveType parse(String name) {
        return NameMap.map.get(name);
    }

    private JPrimitiveType(String name, String boxedName, char jni, String defaultValue) {
        this.name = name;
        this.boxedName = boxedName;
        this.jni = String.valueOf(jni);
        this.defaultValue = defaultValue;
    }

    @Override
    public JType getErasedType() {
        return this;
    }

    @Override
    public String getJNISignature() {
        return this.jni;
    }

    @Override
    public JType getLeafType() {
        return this;
    }

    @Override
    public String getParameterizedQualifiedSourceName() {
        return this.name;
    }

    @Override
    public String getQualifiedBinaryName() {
        return this.name;
    }

    public String getQualifiedBoxedSourceName() {
        return "java.lang." + this.boxedName;
    }

    @Override
    public String getQualifiedSourceName() {
        return this.name;
    }

    @Override
    public String getSimpleSourceName() {
        return this.name;
    }

    public String getUninitializedFieldExpression() {
        return this.defaultValue;
    }

    @Override
    public JAnnotationType isAnnotation() {
        return null;
    }

    @Override
    public JArrayType isArray() {
        return null;
    }

    @Override
    public JClassType isClass() {
        return null;
    }

    @Override
    public JClassType isClassOrInterface() {
        return null;
    }

    @Override
    public JEnumType isEnum() {
        return null;
    }

    @Override
    public JGenericType isGenericType() {
        return null;
    }

    @Override
    public JClassType isInterface() {
        return null;
    }

    @Override
    public JParameterizedType isParameterized() {
        return null;
    }

    @Override
    public JPrimitiveType isPrimitive() {
        return this;
    }

    @Override
    public JRawType isRawType() {
        return null;
    }

    @Override
    public JTypeParameter isTypeParameter() {
        return null;
    }

    @Override
    public JWildcardType isWildcard() {
        return null;
    }

    public String toString() {
        return this.name;
    }

    private static class NameMap {
        static final Map<String, JPrimitiveType> map = new HashMap<String, JPrimitiveType>();

        private NameMap() {
        }

        static {
            for (JPrimitiveType type : JPrimitiveType.values()) {
                map.put(type.getSimpleSourceName(), type);
            }
        }
    }
}

