/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.soyc.impl;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.soyc.ClassMember;
import com.google.gwt.core.ext.soyc.FieldMember;
import com.google.gwt.core.ext.soyc.Member;
import com.google.gwt.core.ext.soyc.MethodMember;
import com.google.gwt.core.ext.soyc.Range;
import com.google.gwt.core.ext.soyc.impl.AbstractMember;
import com.google.gwt.core.ext.soyc.impl.MemberFactory;
import com.google.gwt.core.ext.soyc.impl.SizeMapRecorder;
import com.google.gwt.core.ext.soyc.impl.StandardClassMember;
import com.google.gwt.core.ext.soyc.impl.StoryImpl;
import com.google.gwt.dev.jjs.Correlation;
import com.google.gwt.dev.jjs.JsSourceMap;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.util.Util;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.util.tools.Utility;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.zip.GZIPOutputStream;

public class StoryRecorder {
    private static final int MAX_STRING_BUILDER_SIZE = 65536;
    private StringBuilder builder;
    private int curHighestFragment = 0;
    private OutputStream gzipStream;
    private String[] js;
    private int lastEnd = 0;
    private transient Map<Correlation, Member> membersByCorrelation = new IdentityHashMap<Correlation, Member>();
    private transient Map<SourceInfo, StoryImpl> storyCache = new IdentityHashMap<SourceInfo, StoryImpl>();

    public static void recordStories(TreeLogger logger, OutputStream out, List<JsSourceMap> sourceInfoMaps, String[] js) {
        new StoryRecorder().recordStoriesImpl(logger, out, sourceInfoMaps, js);
    }

    private StoryRecorder() {
    }

    protected void recordStoriesImpl(TreeLogger logger, OutputStream out, List<JsSourceMap> sourceInfoMaps, String[] js) {
        logger = logger.branch(TreeLogger.INFO, "Creating Stories file for the compile report");
        this.js = js;
        try {
            this.builder = new StringBuilder(131072);
            this.gzipStream = new GZIPOutputStream(out);
            MemberFactory memberFactory = new MemberFactory();
            TreeSet<Member> classesMutable = new TreeSet<Member>(Member.SOURCE_NAME_COMPARATOR);
            HashSet<SourceInfo> sourceInfoSeen = new HashSet<SourceInfo>();
            this.builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<soyc>\n<stories>\n");
            int fragment = 0;
            for (JsSourceMap sourceInfoMap : sourceInfoMaps) {
                this.lastEnd = 0;
                this.analyzeFragment(memberFactory, classesMutable, sourceInfoMap, sourceInfoSeen, fragment++);
                this.flushOutput();
            }
            this.builder.append("</stories>\n</soyc>\n");
            this.membersByCorrelation = null;
            this.storyCache = null;
            Util.writeUtf8(this.builder, this.gzipStream);
            Utility.close(this.gzipStream);
            logger.log(TreeLogger.INFO, "Done");
        }
        catch (Throwable e) {
            logger.log(TreeLogger.WARN, "Could not write dependency file; proceeding anyway.", e);
        }
    }

    private void analyzeFragment(MemberFactory memberFactory, TreeSet<ClassMember> classesMutable, JsSourceMap sourceInfoMap, Set<SourceInfo> sourceInfoSeen, int fragment) throws IOException {
        ArrayList<Range> dependencyOrder = Lists.newArrayList(sourceInfoMap.getRanges());
        Collections.sort(dependencyOrder, Range.DEPENDENCY_ORDER_COMPARATOR);
        Stack<RangeInfo> dependencyScope = new Stack<RangeInfo>();
        for (Range range : dependencyOrder) {
            SourceInfo info = range.getSourceInfo();
            assert (info != null);
            while (!dependencyScope.isEmpty() && !dependencyScope.peek().range.contains(range)) {
                this.popAndRecord(dependencyScope, fragment);
            }
            if (!sourceInfoSeen.contains(info)) {
                sourceInfoSeen.add(info);
                block7: for (Correlation c : info.getCorrelations()) {
                    if (c == null || this.membersByCorrelation.containsKey(c)) continue;
                    switch (c.getAxis()) {
                        case CLASS: {
                            JDeclaredType type = c.getType();
                            StandardClassMember member = memberFactory.get(type);
                            this.membersByCorrelation.put(c, member);
                            classesMutable.add(member);
                            continue block7;
                        }
                        case FIELD: {
                            JField field = c.getField();
                            JDeclaredType type = c.getType();
                            AbstractMember member = memberFactory.get(field);
                            memberFactory.get(type).addField((FieldMember)((Object)member));
                            this.membersByCorrelation.put(c, member);
                            continue block7;
                        }
                        case METHOD: {
                            JMethod method = c.getMethod();
                            JDeclaredType type = c.getType();
                            AbstractMember member = memberFactory.get(method);
                            memberFactory.get(type).addMethod((MethodMember)((Object)member));
                            this.membersByCorrelation.put(c, member);
                            continue block7;
                        }
                    }
                }
            }
            dependencyScope.push(new RangeInfo(range, info));
        }
        while (!dependencyScope.isEmpty()) {
            this.popAndRecord(dependencyScope, fragment);
        }
        assert (((Range)dependencyOrder.get(0)).getEnd() == this.lastEnd);
    }

    private void emitStory(StoryImpl story, Range range) throws IOException {
        this.builder.append("<story id=\"story");
        this.builder.append(story.getId());
        if (story.getLiteralTypeName() != null) {
            this.builder.append("\" literal=\"");
            this.builder.append(story.getLiteralTypeName());
        }
        this.builder.append("\">\n");
        SortedSet<Member> correlations = story.getMembers();
        if (correlations.size() > 0) {
            this.builder.append("<correlations>\n");
            for (Member correlation : correlations) {
                this.builder.append("<by idref=\"");
                this.builder.append(correlation.getSourceName());
                this.builder.append("\"/>\n");
                this.flushOutput();
            }
            this.builder.append("</correlations>\n");
        }
        this.builder.append("<js fragment=\"");
        this.builder.append(this.curHighestFragment);
        this.builder.append("\"/>\n<storyref idref=\"story");
        this.builder.append(story.getId());
        int start = range.getStart();
        int end = range.getEnd();
        String jsCode = this.js[this.curHighestFragment];
        if (start == end || end == start + 1 && jsCode.charAt(start) == '\n') {
            this.builder.append("\"/>\n</story>\n");
        } else {
            this.builder.append("\">");
            SizeMapRecorder.escapeXml(jsCode, start, Math.min(end, jsCode.length()), false, this.builder);
            this.builder.append("</storyref>\n</story>\n");
        }
    }

    private void flushOutput() throws IOException {
        if (this.builder.length() > 65536) {
            Util.writeUtf8(this.builder, this.gzipStream);
            this.builder.setLength(0);
        }
    }

    private void popAndRecord(Stack<RangeInfo> dependencyScope, int fragment) throws IOException {
        Range newRange;
        RangeInfo rangeInfo = dependencyScope.pop();
        Range toStore = rangeInfo.range;
        if (this.lastEnd < toStore.getStart() && !dependencyScope.isEmpty()) {
            newRange = new Range(this.lastEnd, toStore.getStart());
            assert (!dependencyScope.isEmpty());
            SourceInfo gapInfo = dependencyScope.peek().info;
            this.recordStory(gapInfo, fragment, newRange.length(), newRange);
            this.lastEnd += newRange.length();
        }
        if (this.lastEnd < toStore.getEnd()) {
            newRange = new Range(Math.max(this.lastEnd, toStore.getStart()), toStore.getEnd());
            this.recordStory(rangeInfo.info, fragment, newRange.length(), newRange);
            this.lastEnd += newRange.length();
        }
    }

    private void recordStory(SourceInfo info, int fragment, int length, Range range) throws IOException {
        StoryImpl theStory;
        assert (info != null);
        assert (this.storyCache != null);
        if (fragment > this.curHighestFragment) {
            this.curHighestFragment = fragment;
        }
        if (!this.storyCache.containsKey(info)) {
            TreeSet<Member> members = new TreeSet<Member>(Member.TYPE_AND_SOURCE_NAME_COMPARATOR);
            for (Correlation c : info.getCorrelations()) {
                Member m = this.membersByCorrelation.get(c);
                if (m == null) continue;
                members.add(m);
            }
            String literalType = null;
            Correlation literalCorrelation = info.getCorrelation(Correlation.Axis.LITERAL);
            if (literalCorrelation != null) {
                literalType = literalCorrelation.getLiteral().getDescription();
            }
            theStory = new StoryImpl(this.storyCache.size(), members, literalType, fragment, length);
            this.storyCache.put(info, theStory);
        } else {
            theStory = new StoryImpl(this.storyCache.get(info), length);
        }
        if (range.getStart() < this.js[this.curHighestFragment].length()) {
            this.emitStory(theStory, range);
        }
    }

    private static class RangeInfo {
        public final SourceInfo info;
        public final Range range;

        public RangeInfo(Range range, SourceInfo info) {
            assert (range != null);
            assert (info != null);
            this.range = range;
            this.info = info;
        }
    }
}

