/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.soyc.impl;

import com.google.gwt.core.ext.soyc.ClassMember;
import com.google.gwt.core.ext.soyc.FieldMember;
import com.google.gwt.core.ext.soyc.Member;
import com.google.gwt.core.ext.soyc.MethodMember;
import com.google.gwt.core.ext.soyc.impl.AbstractMemberWithDependencies;
import com.google.gwt.core.ext.soyc.impl.MemberFactory;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import java.util.Collections;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.TreeSet;

public class StandardClassMember
extends AbstractMemberWithDependencies
implements ClassMember {
    private final MemberFactory factory;
    private final SortedSet<FieldMember> fields = new TreeSet<Member>(Member.SOURCE_NAME_COMPARATOR);
    private final SortedSet<FieldMember> fieldsView = Collections.unmodifiableSortedSet(this.fields);
    private final SortedSet<MethodMember> methods = new TreeSet<Member>(Member.SOURCE_NAME_COMPARATOR);
    private final SortedSet<MethodMember> methodsView = Collections.unmodifiableSortedSet(this.methods);
    private SortedSet<ClassMember> overridesView;
    private final String packageName;
    private final String sourceName;
    private final JDeclaredType type;

    public StandardClassMember(MemberFactory factory, JDeclaredType type) {
        this.factory = factory;
        this.type = type;
        int index = type.getName().lastIndexOf(46);
        this.packageName = index < 0 ? "" : type.getName().substring(0, index).intern();
        this.sourceName = type.getName().intern();
    }

    public void addField(FieldMember field) {
        this.fields.add(field);
    }

    public void addMethod(MethodMember method) {
        this.methods.add(method);
    }

    @Override
    public SortedSet<FieldMember> getFields() {
        return this.fieldsView;
    }

    @Override
    public SortedSet<MethodMember> getMethods() {
        return this.methodsView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<ClassMember> getOverrides() {
        Class<StandardClassMember> clazz = StandardClassMember.class;
        synchronized (StandardClassMember.class) {
            if (this.overridesView == null) {
                this.computeOverrides();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.overridesView;
        }
    }

    @Override
    public String getPackage() {
        return this.packageName;
    }

    @Override
    public String getSourceName() {
        return this.sourceName;
    }

    public String toString() {
        return "ClassMember " + this.getSourceName();
    }

    private void computeOverrides() {
        HashSet<JDeclaredType> seen = new HashSet<JDeclaredType>();
        HashSet<JDeclaredType> toTraverse = new HashSet<JDeclaredType>();
        toTraverse.add(this.type);
        TreeSet<Member> overrides = new TreeSet<Member>(Member.SOURCE_NAME_COMPARATOR);
        while (!toTraverse.isEmpty()) {
            JDeclaredType currentType = (JDeclaredType)toTraverse.iterator().next();
            seen.add(currentType);
            if (currentType != this.type) {
                overrides.add(this.factory.get(currentType));
            }
            if (currentType.getSuperClass() != null) {
                toTraverse.add(currentType.getSuperClass());
            }
            toTraverse.addAll(currentType.getImplements());
            toTraverse.removeAll(seen);
        }
        this.overridesView = Collections.unmodifiableSortedSet(overrides);
    }
}

