/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.soyc.impl;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.impl.JavaToJavaScriptMap;
import com.google.gwt.dev.js.SizeBreakdown;
import com.google.gwt.dev.js.ast.JsLiteral;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsStringLiteral;
import com.google.gwt.dev.util.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.GZIPOutputStream;

public class SizeMapRecorder {
    private static final Comparator<JsName> JSNAME_SORT = new Comparator<JsName>(){

        @Override
        public int compare(JsName o1, JsName o2) {
            return o1.getIdent().compareTo(o2.getIdent());
        }
    };

    public static StringBuilder charToHex(char c) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuilder toReturn = new StringBuilder();
        byte charByte = (byte)(c >>> 8);
        toReturn.append(hexDigit[charByte >> 4 & 0xF]);
        toReturn.append(hexDigit[charByte & 0xF]);
        charByte = (byte)(c & 0xFF);
        toReturn.append(hexDigit[charByte >> 4 & 0xF]);
        toReturn.append(hexDigit[charByte & 0xF]);
        return toReturn;
    }

    public static String escapeXml(String unescaped) {
        StringBuilder builder = new StringBuilder();
        SizeMapRecorder.escapeXml(unescaped, 0, unescaped.length(), true, builder);
        return builder.toString();
    }

    public static void escapeXml(String code, int start, int end, boolean quoteApostrophe, StringBuilder builder) {
        int lastIndex = 0;
        int len = end - start;
        char[] c = new char[len];
        code.getChars(start, end, c, 0);
        for (int i = 0; i < len; ++i) {
            if (c[i] < ' ') {
                builder.append(c, lastIndex, i - lastIndex);
                if (c[i] == '\u0000') {
                    builder.append("\\0");
                } else if (c[i] == '\t') {
                    builder.append("\\t");
                } else if (c[i] == '\n') {
                    builder.append("\\n");
                } else if (c[i] == '\r') {
                    builder.append("\\r");
                } else {
                    builder.append("(invalid xml character: \\u" + SizeMapRecorder.charToHex(c[i]) + ")");
                }
                lastIndex = i + 1;
                continue;
            }
            if (c[i] >= '\u007f' && c[i] <= '\u0084' || c[i] >= '\u0086' && c[i] <= '\u009f' || c[i] >= '\ud800' && c[i] <= '\udbff' || c[i] >= '\udc00' && c[i] <= '\udfff' || c[i] >= '\ufdd0' && c[i] <= '\ufddf' || c[i] == '\u00a0' || c[i] == '\uffff' || c[i] == '\ufffe') {
                builder.append(c, lastIndex, i - lastIndex);
                builder.append("(invalid xml character: \\u" + SizeMapRecorder.charToHex(c[i]) + ")");
                lastIndex = i + 1;
                continue;
            }
            if (c[i] == '&') {
                builder.append(c, lastIndex, i - lastIndex);
                builder.append("&amp;");
                lastIndex = i + 1;
                continue;
            }
            if (c[i] == '>') {
                builder.append(c, lastIndex, i - lastIndex);
                builder.append("&gt;");
                lastIndex = i + 1;
                continue;
            }
            if (c[i] == '<') {
                builder.append(c, lastIndex, i - lastIndex);
                builder.append("&lt;");
                lastIndex = i + 1;
                continue;
            }
            if (c[i] == '\"') {
                builder.append(c, lastIndex, i - lastIndex);
                builder.append("&quot;");
                lastIndex = i + 1;
                continue;
            }
            if (c[i] == '\'') {
                if (!quoteApostrophe) continue;
                builder.append(c, lastIndex, i - lastIndex);
                builder.append("&apos;");
                lastIndex = i + 1;
                continue;
            }
            if (c[i] <= '\u007f') continue;
            builder.append(c, lastIndex, i - lastIndex);
            builder.append("&#x" + SizeMapRecorder.charToHex(c[i]) + ";");
            lastIndex = i + 1;
        }
        builder.append(c, lastIndex, len - lastIndex);
    }

    public static void recordMap(TreeLogger logger, OutputStream out, SizeBreakdown[] sizeBreakdowns, JavaToJavaScriptMap jjsmap, Map<JsName, JsLiteral> internedLiteralByVariableName) throws IOException {
        out = new GZIPOutputStream(out);
        OutputStreamWriter writer = new OutputStreamWriter(out, Util.DEFAULT_ENCODING);
        ((Writer)writer).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        ((Writer)writer).append("<sizemaps>\n");
        for (int i = 0; i < sizeBreakdowns.length; ++i) {
            ((Writer)writer).append("<sizemap fragment=\"" + i + "\" size=\"" + sizeBreakdowns[i].getSize() + "\">\n");
            TreeMap<JsName, Integer> sizeMap = new TreeMap<JsName, Integer>(JSNAME_SORT);
            sizeMap.putAll(sizeBreakdowns[i].getSizeMap());
            for (Map.Entry sizeMapEntry : sizeMap.entrySet()) {
                JsName name = (JsName)sizeMapEntry.getKey();
                int size = (Integer)sizeMapEntry.getValue();
                TypedProgramReference typedRef = SizeMapRecorder.typedProgramReference(name, jjsmap, internedLiteralByVariableName);
                ((Writer)writer).append("  <size type=\"" + SizeMapRecorder.escapeXml(typedRef.type) + "\" ref=\"" + SizeMapRecorder.escapeXml(typedRef.description) + "\" size=\"" + size + "\"/>\n");
            }
            ((Writer)writer).append("</sizemap>\n");
        }
        ((Writer)writer).append("</sizemaps>");
        ((Writer)writer).close();
    }

    private static TypedProgramReference typedProgramReference(JsName name, JavaToJavaScriptMap jjsmap, Map<JsName, JsLiteral> internedLiteralByVariableName) {
        JMethod method = jjsmap.nameToMethod(name);
        if (method != null) {
            return new TypedProgramReference("method", method.getJsniSignature(true, true));
        }
        JField field = jjsmap.nameToField(name);
        if (field != null && field.getEnclosingType() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(field.getEnclosingType().getName());
            sb.append("::");
            sb.append(field.getName());
            return new TypedProgramReference("field", sb.toString());
        }
        JClassType type = jjsmap.nameToType(name);
        if (type != null) {
            return new TypedProgramReference("type", type.getName());
        }
        JsLiteral literal = internedLiteralByVariableName.get(name);
        if (literal instanceof JsStringLiteral) {
            return new TypedProgramReference("string", ((JsStringLiteral)literal).getValue());
        }
        return new TypedProgramReference("var", name.getShortIdent());
    }

    private static class TypedProgramReference {
        public final String description;
        public final String type;

        public TypedProgramReference(String type, String description) {
            this.type = type;
            this.description = description;
        }
    }
}

