/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.soyc.impl;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JRunAsync;
import com.google.gwt.dev.jjs.impl.ControlFlowAnalyzer;
import com.google.gwt.dev.jjs.impl.codesplitter.MultipleDependencyGraphRecorder;
import com.google.gwt.util.tools.Utility;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class DependencyRecorder
implements MultipleDependencyGraphRecorder {
    private final StringBuilder builder = new StringBuilder();
    private final OutputStream finalOutput;
    private OutputStreamWriter writer;

    public DependencyRecorder(OutputStream out) {
        this.finalOutput = out;
    }

    @Override
    public void close() {
        this.printPost();
        this.flushOutput();
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new NestedIOException(e);
        }
    }

    @Override
    public void endDependencyGraph() {
        this.builder.append("</table>");
        this.flushOutput();
    }

    @Override
    public void methodIsLiveBecause(JMethod liveMethod, List<JMethod> dependencyChain) {
        this.printMethodDependency(dependencyChain);
    }

    @Override
    public void open() {
        try {
            this.writer = new OutputStreamWriter((OutputStream)new GZIPOutputStream(this.finalOutput), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalCompilerException("UTF-8 is an unsupported encoding", e);
        }
        catch (IOException e) {
            throw new NestedIOException(e);
        }
        this.printPre();
    }

    @Override
    public void startDependencyGraph(String identifier, String extnds) {
        this.builder.append("<table name=\"");
        this.builder.append(identifier);
        this.builder.append("\"");
        if (extnds != null) {
            this.builder.append(" extends=\"");
            this.builder.append(extnds);
            this.builder.append("\"");
        }
        this.builder.append(">\n");
    }

    protected void recordDependenciesImpl(TreeLogger logger, JProgram jprogram) {
        logger = logger.branch(TreeLogger.DEBUG, "Creating dependencies file for the compile report");
        ControlFlowAnalyzer dependencyAnalyzer = new ControlFlowAnalyzer(jprogram);
        dependencyAnalyzer.setDependencyRecorder(this);
        try {
            this.printPre();
            for (JMethod method : jprogram.getEntryMethods()) {
                dependencyAnalyzer.traverseFrom(method);
                this.maybeFlushOutput();
            }
            for (JRunAsync runAsync : jprogram.getRunAsyncs()) {
                dependencyAnalyzer.traverseFromRunAsync(runAsync);
                this.maybeFlushOutput();
            }
            this.printPost();
            this.flushOutput();
            Utility.close(this.writer);
        }
        catch (Throwable e) {
            logger.log(TreeLogger.WARN, "Could not write dependency file; proceeding anyway.", e);
        }
    }

    private void flushOutput() {
        try {
            this.writer.write(this.builder.toString());
        }
        catch (IOException e) {
            throw new NestedIOException(e);
        }
        this.builder.setLength(0);
    }

    private void maybeFlushOutput() {
        if (this.builder.length() > 8192) {
            this.flushOutput();
        }
    }

    private void printMethodDependency(List<JMethod> dependencyChain) {
        int size = dependencyChain.size();
        if (size < 2) {
            return;
        }
        this.printMethodDependencyBetween(dependencyChain.get(size - 1), dependencyChain.get(size - 2));
    }

    protected void printMethodDependencyBetween(JMethod curMethod, JMethod depMethod) {
        this.builder.append("<method name=\"");
        if (curMethod.getEnclosingType() != null) {
            this.builder.append(curMethod.getEnclosingType().getName());
            this.builder.append("::");
        }
        this.builder.append(curMethod.getName());
        this.builder.append("\">\n");
        this.builder.append("<called by=\"");
        if (depMethod.getEnclosingType() != null) {
            this.builder.append(depMethod.getEnclosingType().getName());
            this.builder.append("::");
        }
        this.builder.append(depMethod.getName());
        this.builder.append("\"/>\n");
        this.builder.append("</method>\n");
    }

    private void printPost() {
        this.builder.append("</soyc-dependencies>\n");
    }

    private void printPre() {
        this.builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<soyc-dependencies>\n");
    }

    public static class NestedIOException
    extends RuntimeException {
        public NestedIOException(IOException e) {
            super(e);
        }
    }
}

