/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.soyc.coderef;

import com.google.gwt.core.ext.soyc.coderef.ClassDescriptor;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class PackageDescriptor {
    public static final String DEFAULT_PKG = "<default>";
    private ArrayList<PackageDescriptor> packages = Lists.newArrayList();
    private ArrayList<ClassDescriptor> classes = Lists.newArrayList();
    private String name = "<default>";
    private String longName = "";

    public static PackageDescriptor from(Map<String, ClassDescriptor> codeModel) {
        PackageDescriptor topPackage = new PackageDescriptor(DEFAULT_PKG, "");
        for (ClassDescriptor classDescriptor : codeModel.values()) {
            PackageDescriptor packageDescriptor = topPackage;
            if (!classDescriptor.getPackageName().equals(topPackage.longName)) {
                for (String packageName : classDescriptor.getPackageName().split("\\.")) {
                    packageDescriptor = packageDescriptor.createOrGetChildPackage(packageName);
                }
            }
            packageDescriptor.addClass(classDescriptor);
        }
        topPackage.collapseEmptyPackages();
        return topPackage;
    }

    public PackageDescriptor(String packageName, String longPackageName) {
        this.name = packageName;
        this.longName = longPackageName;
    }

    private void collapseEmptyPackages() {
        if (this.packages.size() == 1 && this.classes.size() == 0) {
            PackageDescriptor childPackage = this.packages.get(0);
            childPackage.collapseEmptyPackages();
            this.name = (this.name.equals(DEFAULT_PKG) ? "" : this.name + ".") + childPackage.name;
            this.longName = childPackage.longName;
            this.packages = childPackage.packages;
            this.classes = childPackage.classes;
            return;
        }
        for (PackageDescriptor pkg : this.packages) {
            pkg.collapseEmptyPackages();
        }
    }

    private PackageDescriptor createOrGetChildPackage(String packageName) {
        for (PackageDescriptor childPackage : this.packages) {
            if (!childPackage.getName().equals(packageName)) continue;
            return childPackage;
        }
        PackageDescriptor childPackage = new PackageDescriptor(packageName, this.longName.length() > 0 ? this.longName + "." + packageName : packageName);
        this.addPackage(childPackage);
        return childPackage;
    }

    public Map<String, ClassDescriptor> getAllClassesByName() {
        TreeMap<String, ClassDescriptor> map = Maps.newTreeMap();
        this.populateClassesByName(map);
        return map;
    }

    private void populateClassesByName(Map<String, ClassDescriptor> classesByName) {
        for (ClassDescriptor classDescriptor : this.getClasses()) {
            classesByName.put(classDescriptor.getFullName(), classDescriptor);
        }
        for (PackageDescriptor subPackage : this.getPackages()) {
            subPackage.populateClassesByName(classesByName);
        }
    }

    public void addClass(ClassDescriptor cls) {
        this.classes.add(cls);
    }

    public void addPackage(PackageDescriptor pkg) {
        this.packages.add(pkg);
    }

    public Collection<ClassDescriptor> getClasses() {
        return this.classes;
    }

    public String getName() {
        return this.name;
    }

    public Collection<PackageDescriptor> getPackages() {
        return this.packages;
    }
}

