/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.soyc.coderef;

import com.google.gwt.core.ext.soyc.coderef.ClassDescriptor;
import com.google.gwt.core.ext.soyc.coderef.MemberDescriptor;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.Collections;
import java.util.Set;

public class MethodDescriptor
extends MemberDescriptor {
    private final Set<MethodDescriptor> dependentMethods = Sets.newIdentityHashSet();
    private int uniqueId;
    private final String paramTypes;
    private final Set<JMethod> methodReferences = Sets.newIdentityHashSet();
    private static final String CONSTRUCTOR_POSTFIX = " <init>";

    public static MethodDescriptor from(ClassDescriptor classDescriptor, JMethod method, String signature) {
        MethodDescriptor methodDescriptor = new MethodDescriptor(classDescriptor, signature);
        methodDescriptor.methodReferences.add(method);
        return methodDescriptor;
    }

    private MethodDescriptor(ClassDescriptor owner, String[] signatureComponents) {
        super(owner, signatureComponents[0]);
        this.paramTypes = signatureComponents[1];
        this.type = MethodDescriptor.normalizeMethodSignature(signatureComponents[2]);
    }

    public static String normalizeMethodSignature(String methodSignature) {
        if (methodSignature.endsWith(CONSTRUCTOR_POSTFIX)) {
            return methodSignature.substring(0, methodSignature.length() - CONSTRUCTOR_POSTFIX.length()) + "V";
        }
        return methodSignature;
    }

    public MethodDescriptor(ClassDescriptor owner, String jsniSignature) {
        this(owner, jsniSignature.split("\\(|\\)"));
    }

    public void addDependant(MethodDescriptor methodDescriptor) {
        this.dependentMethods.add(methodDescriptor);
    }

    public void addReference(JMethod methodRef) {
        this.methodReferences.add(methodRef);
    }

    public int[] getDependentPointers() {
        int[] ps = new int[this.dependentMethods.size()];
        int c = 0;
        for (MethodDescriptor dependant : this.dependentMethods) {
            ps[c++] = dependant.getUniqueId();
        }
        return ps;
    }

    public Set<MethodDescriptor> getDependentMethods() {
        return Collections.unmodifiableSet(this.dependentMethods);
    }

    @Override
    public String getJsniSignature() {
        return this.name + "(" + this.paramTypes + ")" + this.type;
    }

    public String getParamTypes() {
        return this.paramTypes;
    }

    public Set<JMethod> getMethodReferences() {
        return Collections.unmodifiableSet(this.methodReferences);
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(int uniqueId) {
        this.uniqueId = uniqueId;
    }
}

