/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.soyc.coderef;

import com.google.gwt.core.ext.linker.EmittedArtifact;
import com.google.gwt.core.ext.linker.SyntheticArtifact;
import com.google.gwt.core.ext.soyc.SourceMapRecorder;
import com.google.gwt.core.ext.soyc.coderef.ClassDescriptor;
import com.google.gwt.core.ext.soyc.coderef.DependencyGraphRecorder;
import com.google.gwt.core.ext.soyc.coderef.EntityDescriptor;
import com.google.gwt.core.ext.soyc.coderef.EntityDescriptorJsonTranslator;
import com.google.gwt.core.ext.soyc.coderef.MethodDescriptor;
import com.google.gwt.core.ext.soyc.coderef.PackageDescriptor;
import com.google.gwt.core.linker.SoycReportLinker;
import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.JsSourceMap;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JRunAsync;
import com.google.gwt.dev.jjs.impl.JavaToJavaScriptMap;
import com.google.gwt.dev.jjs.impl.codesplitter.FragmentPartitioningResult;
import com.google.gwt.dev.js.SizeBreakdown;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.json.JSONArray;
import com.google.gwt.thirdparty.json.JSONException;
import com.google.gwt.thirdparty.json.JSONObject;
import com.google.gwt.util.tools.Utility;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class EntityRecorder {
    public static final String ENTITIES = "entities";
    public static final String FRAGMENT_ID = "id";
    public static final String FRAGMENT_SIZE = "size";
    public static final String FRAGMENT_STR_VAR = "strAndVarSize";
    public static final String FRAGMENT_POINTS = "runAsyncs";
    public static final String FRAGMENTS = "fragments";
    public static final String INITIAL_SEQUENCE = "initialSequence";
    private final List<SyntheticArtifact> toReturn = Lists.newArrayList();
    private final int permutationId;
    private final int[] fragmentSizes;
    private final int[] otherSizes;
    private JSONObject[] sizeMetrics;

    public static List<SyntheticArtifact> makeSoycArtifacts(int permutationId, List<JsSourceMap> sourceInfoMaps, String sourceMapFilePrefix, JavaToJavaScriptMap jjsmap, SizeBreakdown[] sizeBreakdowns, DependencyGraphRecorder codeGraph, JProgram jprogram) {
        ArrayList<SyntheticArtifact> artifacts = Lists.newArrayList();
        try {
            EntityRecorder recorder = new EntityRecorder(sizeBreakdowns, permutationId);
            recorder.recordCodeReferences(codeGraph, sizeBreakdowns, jjsmap);
            recorder.recordFragments(jprogram);
            artifacts.addAll(recorder.toReturn);
            artifacts.addAll(SourceMapRecorder.execWithJavaNames(permutationId, sourceInfoMaps, sourceMapFilePrefix));
        }
        catch (Exception e) {
            throw new InternalCompilerException(e.toString(), e);
        }
        return artifacts;
    }

    private EntityRecorder(SizeBreakdown[] sizeBreakdowns, int permutationId) {
        this.fragmentSizes = new int[sizeBreakdowns.length];
        this.otherSizes = new int[sizeBreakdowns.length];
        for (int i = 0; i < sizeBreakdowns.length; ++i) {
            this.fragmentSizes[i] = sizeBreakdowns[i].getSize();
            this.otherSizes[i] = 0;
        }
        this.permutationId = permutationId;
    }

    private JSONObject getSizeMetrics(int fragment) throws JSONException {
        JSONObject obj = new JSONObject();
        obj.put(FRAGMENT_ID, fragment);
        obj.put(FRAGMENT_SIZE, this.fragmentSizes[fragment]);
        obj.put(FRAGMENT_STR_VAR, this.otherSizes[fragment]);
        return obj;
    }

    private void recordCodeReferences(DependencyGraphRecorder codeGraph, SizeBreakdown[] sizeBreakdowns, JavaToJavaScriptMap jjsmap) throws IOException, JSONException {
        this.sizeMetrics = new JSONObject[sizeBreakdowns.length];
        for (int i = 0; i < sizeBreakdowns.length; ++i) {
            for (Map.Entry<JsName, Integer> kv : sizeBreakdowns[i].getSizeMap().entrySet()) {
                JsName name = kv.getKey();
                int size = kv.getValue();
                JMethod method = jjsmap.nameToMethod(name);
                if (method != null) {
                    codeGraph.methodDescriptorFrom(method).addFragment(new EntityDescriptor.Fragment(i, size));
                    continue;
                }
                JField field = jjsmap.nameToField(name);
                if (field != null && field.getEnclosingType() != null) {
                    codeGraph.classDescriptorFrom(field.getEnclosingType()).fieldFrom(field).addFragment(new EntityDescriptor.Fragment(i, size));
                    continue;
                }
                JClassType type = jjsmap.nameToType(name);
                if (type != null) {
                    codeGraph.classDescriptorFrom(type).addFragment(new EntityDescriptor.Fragment(i, size));
                    continue;
                }
                int n = i;
                this.otherSizes[n] = this.otherSizes[n] + size;
            }
            this.sizeMetrics[i] = this.getSizeMetrics(i);
        }
        for (ClassDescriptor cls : codeGraph.getCodeModel().values()) {
            JsName jsName;
            JDeclaredType type = cls.getTypeReference();
            if (type instanceof JClassType && (jsName = jjsmap.nameForType((JClassType)type)) != null) {
                cls.addObfuscatedName(jsName.getShortIdent());
            }
            for (MethodDescriptor mth : cls.getMethods()) {
                for (JMethod jMethod : mth.getMethodReferences()) {
                    JsName jsName2 = jjsmap.nameForMethod(jMethod);
                    if (jsName2 == null) continue;
                    mth.addObfuscatedName(jsName2.getShortIdent());
                }
            }
            for (JField field : type.getFields()) {
                JsName jsName3 = jjsmap.nameForField(field);
                if (jsName3 == null) continue;
                cls.fieldFrom(field).addObfuscatedName(jsName3.getShortIdent());
            }
        }
        this.addArtifactFromJson(EntityDescriptorJsonTranslator.writeJson(PackageDescriptor.from(codeGraph.getCodeModel())), ENTITIES + this.permutationId + ".json");
    }

    private String addArtifactFromJson(Object value, String named) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(baos);
        writer.write(value.toString());
        Utility.close(writer);
        SyntheticArtifact artifact = new SyntheticArtifact(SoycReportLinker.class, named, baos.toByteArray());
        artifact.setVisibility(EmittedArtifact.Visibility.LegacyDeploy);
        this.toReturn.add(artifact);
        return named;
    }

    private void recordFragments(JProgram jprogram) throws IOException, JSONException {
        JSONObject jsonPoints = new JSONObject();
        FragmentPartitioningResult partitionResult = jprogram.getFragmentPartitioningResult();
        if (partitionResult != null) {
            HashMap runAsyncPerFragment = Maps.newHashMap();
            for (JRunAsync runAsync : jprogram.getRunAsyncs()) {
                int fragmentId = partitionResult.getFragmentForRunAsync(runAsync.getRunAsyncId());
                HashSet<String> runAsyncNames = (HashSet<String>)runAsyncPerFragment.get(fragmentId);
                if (runAsyncNames == null) {
                    runAsyncNames = Sets.newHashSet();
                }
                runAsyncNames.add(runAsync.getName());
                runAsyncPerFragment.put(fragmentId, runAsyncNames);
            }
            for (Integer idx : runAsyncPerFragment.keySet()) {
                this.sizeMetrics[idx].put(FRAGMENT_POINTS, runAsyncPerFragment.get(idx));
            }
            JSONArray initialSequence = new JSONArray();
            for (int fragId : jprogram.getInitialFragmentIdSequence()) {
                initialSequence.put(partitionResult.getFragmentForRunAsync(fragId));
            }
            jsonPoints.put(INITIAL_SEQUENCE, initialSequence);
        }
        jsonPoints.put(FRAGMENTS, this.sizeMetrics);
        this.addArtifactFromJson(jsonPoints, FRAGMENTS + this.permutationId + ".json");
    }
}

