/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.soyc.coderef;

import com.google.gwt.core.ext.soyc.coderef.ClassDescriptor;
import com.google.gwt.core.ext.soyc.coderef.EntityDescriptor;
import com.google.gwt.core.ext.soyc.coderef.FieldDescriptor;
import com.google.gwt.core.ext.soyc.coderef.MemberDescriptor;
import com.google.gwt.core.ext.soyc.coderef.MethodDescriptor;
import com.google.gwt.core.ext.soyc.coderef.PackageDescriptor;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.json.JSONArray;
import com.google.gwt.thirdparty.json.JSONException;
import com.google.gwt.thirdparty.json.JSONObject;
import java.util.Map;

public class EntityDescriptorJsonTranslator {
    public static final String ENTITY_JS = "js";
    public static final String ENTITY_NAME = "name";
    public static final String FIELDS = "fields";
    public static final String METHOD_ID = "id";
    public static final String METHOD_DEPENDENTS = "dependents";
    public static final String METHODS = "methods";
    public static final String CLASSES = "classes";
    public static final String PACKAGES = "packages";

    private static JSONObject writeJsonFromEntity(EntityDescriptor entity) throws JSONException {
        JSONObject json = new JSONObject();
        JSONArray fragments = new JSONArray();
        for (EntityDescriptor.Fragment frg : entity.getFragments()) {
            JSONObject frag = new JSONObject();
            frag.put(METHOD_ID, frg.getId());
            frag.put("size", frg.getSize());
            fragments.put(frag);
        }
        json.put("fragments", fragments);
        json.put(ENTITY_JS, new JSONArray(entity.getObfuscatedNames()));
        return json;
    }

    private static JSONObject writeJsonFromMember(MemberDescriptor entity) throws JSONException {
        JSONObject json = EntityDescriptorJsonTranslator.writeJsonFromEntity(entity);
        json.put(ENTITY_NAME, entity.getJsniSignature());
        return json;
    }

    public static JSONObject writeJson(PackageDescriptor pkg) throws JSONException {
        JSONObject json = new JSONObject();
        json.put(ENTITY_NAME, pkg.getName());
        JSONArray classes = new JSONArray();
        for (ClassDescriptor classDescriptor : pkg.getClasses()) {
            JSONObject jsonClass = EntityDescriptorJsonTranslator.writeJsonFromEntity(classDescriptor);
            jsonClass.put(ENTITY_NAME, classDescriptor.getName());
            JSONArray fields = new JSONArray();
            for (FieldDescriptor fieldDescriptor : classDescriptor.getFields()) {
                fields.put(EntityDescriptorJsonTranslator.writeJsonFromMember(fieldDescriptor));
            }
            jsonClass.put(FIELDS, fields);
            JSONArray methods = new JSONArray();
            for (MethodDescriptor methodDescriptor : classDescriptor.getMethods()) {
                JSONObject jsonMethod = EntityDescriptorJsonTranslator.writeJsonFromMember(methodDescriptor);
                jsonMethod.put(METHOD_ID, methodDescriptor.getUniqueId());
                jsonMethod.put(METHOD_DEPENDENTS, new JSONArray(methodDescriptor.getDependentPointers()));
                methods.put(jsonMethod);
            }
            jsonClass.put(METHODS, methods);
            classes.put(jsonClass);
        }
        json.put(CLASSES, classes);
        JSONArray packages = new JSONArray();
        for (PackageDescriptor packageDescriptor : pkg.getPackages()) {
            packages.put(EntityDescriptorJsonTranslator.writeJson(packageDescriptor));
        }
        json.put(PACKAGES, packages);
        return json;
    }

    public static PackageDescriptor readJson(JSONObject jsonObject) throws JSONException {
        return new Deserializer().readJson(jsonObject);
    }

    private EntityDescriptorJsonTranslator() {
    }

    private static class Deserializer {
        private final Map<Integer, MethodDescriptor> mapMethods = Maps.newHashMap();
        private final Map<MethodDescriptor, JSONArray> mapDependants = Maps.newIdentityHashMap();

        private Deserializer() {
        }

        private PackageDescriptor readJson(JSONObject jsonObject) throws JSONException {
            String packageName;
            PackageDescriptor packageDescriptor = this.readJsonPackage(jsonObject, packageName, (packageName = jsonObject.getString(EntityDescriptorJsonTranslator.ENTITY_NAME)).equals("<default>") ? "" : packageName);
            this.setMethodDependencies();
            return packageDescriptor;
        }

        private void setMethodDependencies() throws JSONException {
            for (MethodDescriptor method : this.mapDependants.keySet()) {
                JSONArray dependants = this.mapDependants.get(method);
                for (int i = 0; i < dependants.length(); ++i) {
                    method.addDependant(this.mapMethods.get(dependants.getInt(i)));
                }
            }
        }

        private PackageDescriptor readJsonPackage(JSONObject jsonObject, String name, String longName) throws JSONException {
            PackageDescriptor descriptor = new PackageDescriptor(name, longName);
            JSONArray clss = jsonObject.getJSONArray(EntityDescriptorJsonTranslator.CLASSES);
            for (int i = 0; i < clss.length(); ++i) {
                descriptor.addClass(this.readJsonClass(clss.getJSONObject(i), longName));
            }
            JSONArray packages = jsonObject.getJSONArray(EntityDescriptorJsonTranslator.PACKAGES);
            for (int i = 0; i < packages.length(); ++i) {
                JSONObject subPackage = packages.getJSONObject(i);
                String packageName = subPackage.getString(EntityDescriptorJsonTranslator.ENTITY_NAME);
                descriptor.addPackage(this.readJsonPackage(subPackage, packageName, longName + (longName.isEmpty() ? "" : ".") + packageName));
            }
            return descriptor;
        }

        private ClassDescriptor readJsonClass(JSONObject jsonObject, String packageName) throws JSONException {
            ClassDescriptor descriptor = new ClassDescriptor(jsonObject.getString(EntityDescriptorJsonTranslator.ENTITY_NAME), packageName);
            this.updateEntity(descriptor, jsonObject);
            JSONArray fields = jsonObject.getJSONArray(EntityDescriptorJsonTranslator.FIELDS);
            for (int i = 0; i < fields.length(); ++i) {
                descriptor.addField(this.readJsonField(fields.getJSONObject(i), descriptor));
            }
            JSONArray methods = jsonObject.getJSONArray(EntityDescriptorJsonTranslator.METHODS);
            for (int i = 0; i < methods.length(); ++i) {
                descriptor.addMethod(this.readJsonMethod(methods.getJSONObject(i), descriptor));
            }
            return descriptor;
        }

        private MethodDescriptor readJsonMethod(JSONObject jsonObject, ClassDescriptor classDescriptor) throws JSONException {
            MethodDescriptor method = new MethodDescriptor(classDescriptor, jsonObject.getString(EntityDescriptorJsonTranslator.ENTITY_NAME));
            this.updateEntity(method, jsonObject);
            method.setUniqueId(jsonObject.getInt(EntityDescriptorJsonTranslator.METHOD_ID));
            this.mapMethods.put(method.getUniqueId(), method);
            this.mapDependants.put(method, jsonObject.getJSONArray(EntityDescriptorJsonTranslator.METHOD_DEPENDENTS));
            return method;
        }

        private FieldDescriptor readJsonField(JSONObject jsonObject, ClassDescriptor classDescriptor) throws JSONException {
            String[] fullName = jsonObject.getString(EntityDescriptorJsonTranslator.ENTITY_NAME).split(":");
            FieldDescriptor fieldDescriptor = new FieldDescriptor(classDescriptor, fullName[0], fullName[1]);
            this.updateEntity(fieldDescriptor, jsonObject);
            return fieldDescriptor;
        }

        private void updateEntity(EntityDescriptor entity, JSONObject jsonObject) throws JSONException {
            JSONArray jsNames = jsonObject.getJSONArray(EntityDescriptorJsonTranslator.ENTITY_JS);
            for (int i = 0; i < jsNames.length(); ++i) {
                entity.addObfuscatedName(jsNames.getString(i));
            }
            JSONArray frags = jsonObject.getJSONArray("fragments");
            for (int i = 0; i < frags.length(); ++i) {
                JSONObject frag = frags.getJSONObject(i);
                entity.addFragment(new EntityDescriptor.Fragment(frag.getInt(EntityDescriptorJsonTranslator.METHOD_ID), frag.getInt("size")));
            }
        }
    }
}

