/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.soyc.coderef;

import com.google.gwt.core.ext.soyc.coderef.ClassDescriptor;
import com.google.gwt.core.ext.soyc.coderef.MethodDescriptor;
import com.google.gwt.core.ext.soyc.impl.DependencyRecorder;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import java.io.OutputStream;
import java.util.Map;

public class DependencyGraphRecorder
extends DependencyRecorder {
    private Map<String, ClassDescriptor> codeModel = Maps.newTreeMap();
    private int nextUniqueId = 0;
    private JProgram jProgram;

    public DependencyGraphRecorder(OutputStream out, JProgram jProgram) {
        super(out);
        this.jProgram = jProgram;
    }

    protected int nextPointerId() {
        return ++this.nextUniqueId;
    }

    public Map<String, ClassDescriptor> getCodeModel() {
        return this.codeModel;
    }

    @Override
    public void startDependencyGraph(String name, String extendz) {
        super.startDependencyGraph(name, extendz);
    }

    @Override
    protected void printMethodDependencyBetween(JMethod curMethod, JMethod depMethod) {
        super.printMethodDependencyBetween(curMethod, depMethod);
        this.methodDescriptorFrom(curMethod).addDependant(this.methodDescriptorFrom(depMethod));
    }

    protected String signatureFor(JMethod method) {
        JMethod instanceMethod = this.jProgram.instanceMethodForStaticImpl(method);
        if (instanceMethod == null) {
            return method.getSignature();
        }
        return instanceMethod.getSignature();
    }

    public MethodDescriptor methodDescriptorFrom(JMethod method) {
        MethodDescriptor mth = this.classDescriptorFrom(method.getEnclosingType()).methodFrom(method, this.signatureFor(method));
        if (!this.isValid(mth.getUniqueId())) {
            mth.setUniqueId(this.nextPointerId());
        }
        return mth;
    }

    protected boolean isValid(int n) {
        return n > 0;
    }

    public ClassDescriptor classDescriptorFrom(JDeclaredType classType) {
        ClassDescriptor classDescriptor = this.codeModel.get(classType.getName());
        if (classDescriptor == null) {
            classDescriptor = ClassDescriptor.from(classType);
            this.codeModel.put(classType.getName(), classDescriptor);
        }
        return classDescriptor;
    }
}

