/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.soyc.coderef;

import com.google.gwt.core.ext.soyc.coderef.EntityDescriptor;
import com.google.gwt.core.ext.soyc.coderef.FieldDescriptor;
import com.google.gwt.core.ext.soyc.coderef.MethodDescriptor;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.util.Util;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class ClassDescriptor
extends EntityDescriptor {
    private final String packageName;
    private final Map<String, MethodDescriptor> methodsByJsniSignature = Maps.newTreeMap();
    private final Map<String, FieldDescriptor> fieldsByName = Maps.newTreeMap();
    private final JDeclaredType typeReference;

    public static ClassDescriptor from(JDeclaredType classType) {
        return new ClassDescriptor(Util.getClassName(classType.getName()), Util.getPackageName(classType.getName()), classType);
    }

    private ClassDescriptor(String className, String packageName, JDeclaredType classType) {
        super(className);
        this.packageName = packageName;
        this.typeReference = classType;
    }

    public ClassDescriptor(String className, String packageName) {
        this(className, packageName, null);
    }

    public void addField(FieldDescriptor fieldDescriptor) {
        this.fieldsByName.put(fieldDescriptor.getName(), fieldDescriptor);
    }

    public void addMethod(MethodDescriptor methodDescriptor) {
        this.methodsByJsniSignature.put(methodDescriptor.getJsniSignature(), methodDescriptor);
    }

    public FieldDescriptor fieldFrom(JField field) {
        FieldDescriptor descriptor = this.fieldsByName.get(field.getName());
        if (descriptor == null) {
            descriptor = FieldDescriptor.from(this, field);
            this.fieldsByName.put(field.getName(), descriptor);
        }
        return descriptor;
    }

    public FieldDescriptor getField(String fieldName) {
        return this.fieldsByName.get(fieldName);
    }

    public Collection<FieldDescriptor> getFields() {
        return Collections.unmodifiableCollection(this.fieldsByName.values());
    }

    @Override
    public String getFullName() {
        if (this.packageName.isEmpty()) {
            return this.name;
        }
        return this.packageName + "." + this.name;
    }

    public MethodDescriptor getMethod(String methodSignature) {
        methodSignature = MethodDescriptor.normalizeMethodSignature(methodSignature);
        return this.methodsByJsniSignature.get(methodSignature);
    }

    public Collection<MethodDescriptor> getMethods() {
        return Collections.unmodifiableCollection(this.methodsByJsniSignature.values());
    }

    public String getPackageName() {
        return this.packageName;
    }

    public JDeclaredType getTypeReference() {
        return this.typeReference;
    }

    public MethodDescriptor methodFrom(JMethod method, String signature) {
        MethodDescriptor methodDescriptor = this.methodsByJsniSignature.get(signature = MethodDescriptor.normalizeMethodSignature(signature));
        if (methodDescriptor == null) {
            methodDescriptor = MethodDescriptor.from(this, method, signature);
            this.methodsByJsniSignature.put(signature, methodDescriptor);
        } else {
            methodDescriptor.addReference(method);
        }
        return methodDescriptor;
    }
}

