/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.soyc;

import com.google.gwt.core.ext.soyc.Range;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.thirdparty.debugging.sourcemap.FilePosition;
import com.google.gwt.thirdparty.debugging.sourcemap.SourceMapGenerator;

class SourceMappingWriter {
    private final SourceMapGenerator out;
    private boolean empty;
    private String javaFile;
    private int javaLine;
    private int startLine;
    private int startColumn;
    private int endLine;
    private int endColumn;

    SourceMappingWriter(SourceMapGenerator out) {
        this.out = out;
        this.empty = true;
    }

    void addMapping(Range nextRange, String javaName) {
        SourceInfo nextInfo = nextRange.getSourceInfo();
        if (!this.canMerge(nextRange, nextInfo, javaName)) {
            this.flush(null);
        }
        if (this.empty) {
            this.javaFile = nextInfo.getFileName();
            this.javaLine = nextInfo.getStartLine();
            this.startLine = nextRange.getStartLine();
            this.startColumn = nextRange.getStartColumn();
            this.endLine = nextRange.getEndLine();
            this.endColumn = nextRange.getEndColumn();
            this.empty = false;
            if (javaName != null) {
                this.flush(javaName);
            }
            return;
        }
        int nextEndLine = nextRange.getEndLine();
        if (nextEndLine < this.endLine) {
            return;
        }
        int nextEndColumn = nextRange.getEndColumn();
        if (nextEndLine == this.endLine && nextEndColumn <= this.endColumn) {
            return;
        }
        this.endLine = nextEndLine;
        this.endColumn = nextEndColumn;
    }

    void flush() {
        this.flush(null);
    }

    private boolean canMerge(Range nextRange, SourceInfo nextInfo, String javaName) {
        if (this.empty) {
            return false;
        }
        if (javaName != null) {
            return false;
        }
        if (this.endLine < nextRange.getStartLine()) {
            return false;
        }
        if (this.endLine == nextRange.getStartLine() && this.endColumn < nextRange.getStartColumn()) {
            return false;
        }
        if (this.javaLine != nextInfo.getStartLine()) {
            return false;
        }
        return this.javaFile.equals(nextInfo.getFileName());
    }

    private void flush(String javaName) {
        if (this.empty) {
            return;
        }
        this.out.addMapping(this.javaFile, javaName, new FilePosition(this.javaLine - 1, 0), new FilePosition(this.startLine, this.startColumn), new FilePosition(this.endLine, this.endColumn));
        this.empty = true;
    }
}

