/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.soyc;

import com.google.gwt.core.ext.linker.SyntheticArtifact;
import com.google.gwt.core.ext.soyc.Range;
import com.google.gwt.core.ext.soyc.SourceMappingWriter;
import com.google.gwt.core.linker.SymbolMapsLinker;
import com.google.gwt.dev.jjs.Correlation;
import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.JsSourceMap;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceInfoCorrelation;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.debugging.sourcemap.SourceMapGeneratorV3;
import com.google.gwt.thirdparty.debugging.sourcemap.SourceMapParseException;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SourceMapRecorder {
    private final int permutationId;
    private final List<JsSourceMap> fragmentMaps;
    private final String sourceRoot;
    private boolean wantJavaNames;

    public static List<SyntheticArtifact> exec(int permutationId, List<JsSourceMap> fragmentMaps, String sourceFilePrefix) {
        try {
            return new SourceMapRecorder(permutationId, fragmentMaps, sourceFilePrefix).createArtifacts();
        }
        catch (Exception e) {
            throw new InternalCompilerException(e.toString(), e);
        }
    }

    public static List<SyntheticArtifact> execWithJavaNames(int permutationId, List<JsSourceMap> fragmentMaps, String sourceFilePrefix) {
        try {
            SourceMapRecorder recorder = new SourceMapRecorder(permutationId, fragmentMaps, sourceFilePrefix);
            recorder.wantJavaNames = true;
            return recorder.createArtifacts();
        }
        catch (Exception e) {
            throw new InternalCompilerException(e.toString(), e);
        }
    }

    private SourceMapRecorder(int permutationId, List<JsSourceMap> fragmentMaps, String sourceRoot) {
        this.permutationId = permutationId;
        this.fragmentMaps = fragmentMaps;
        this.sourceRoot = sourceRoot;
    }

    private List<SyntheticArtifact> createArtifacts() throws IOException, SourceMapParseException {
        SpeedTracerLogger.Event event = SpeedTracerLogger.start(CompilerEventType.SOURCE_MAP_RECORDER, new String[0]);
        ArrayList<SyntheticArtifact> toReturn = Lists.newArrayList();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SourceMapGeneratorV3 generator = new SourceMapGeneratorV3();
        int fragment = 0;
        for (JsSourceMap sourceMap : this.fragmentMaps) {
            generator.reset();
            if (this.sourceRoot != null) {
                generator.setSourceRoot(this.sourceRoot);
            }
            this.addExtensions(generator, fragment);
            this.addMappings(new SourceMappingWriter(generator), sourceMap);
            baos.reset();
            OutputStreamWriter out = new OutputStreamWriter(baos);
            generator.appendTo(out, "sourceMap" + fragment);
            out.flush();
            toReturn.add(new SymbolMapsLinker.SourceMapArtifact(this.permutationId, fragment, baos.toByteArray(), this.sourceRoot));
            ++fragment;
        }
        event.end(new String[0]);
        return toReturn;
    }

    private void addExtensions(SourceMapGeneratorV3 generator, int fragment) throws SourceMapParseException {
        generator.addExtension("x_gwt_permutation", this.permutationId);
        generator.addExtension("x_gwt_fragment", fragment);
    }

    private void addMappings(SourceMappingWriter output, JsSourceMap mappings) {
        ArrayList<Range> ranges = Lists.newArrayList(mappings.getRanges());
        Collections.sort(ranges, Range.DEPENDENCY_ORDER_COMPARATOR);
        for (Range range : ranges) {
            SourceInfo info = range.getSourceInfo();
            output.addMapping(range, this.getJavaName(info));
        }
        output.flush();
    }

    private String getJavaName(SourceInfo sourceInfo) {
        if (!this.wantJavaNames) {
            return null;
        }
        if (!(sourceInfo instanceof SourceInfoCorrelation)) {
            return null;
        }
        Correlation correlation = ((SourceInfoCorrelation)sourceInfo).getPrimaryCorrelation();
        if (correlation == null) {
            return null;
        }
        return correlation.getIdent();
    }
}

