/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.soyc;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;
import java.util.Comparator;

public final class Range {
    public static final Comparator<Range> DEPENDENCY_ORDER_COMPARATOR = new Comparator<Range>(){

        @Override
        public int compare(Range o1, Range o2) {
            int a = o1.start - o2.start;
            if (a != 0) {
                return a;
            }
            return o2.end - o1.end;
        }
    };
    public static final Comparator<Range> SOURCE_ORDER_COMPARATOR = new Comparator<Range>(){

        @Override
        public int compare(Range o1, Range o2) {
            int a = o1.start - o2.start;
            if (a != 0) {
                return a;
            }
            return o1.end - o2.end;
        }
    };
    final int end;
    final int endColumn;
    final int endLine;
    final int start;
    final int startColumn;
    final int startLine;
    final SourceInfo sourceInfo;

    public Range(int start, int end) {
        this(start, end, -1, -1, -1, -1, SourceOrigin.UNKNOWN);
    }

    public Range(int start, int end, SourceInfo sourceInfo) {
        this(start, end, -1, -1, -1, -1, sourceInfo);
    }

    public Range(int start, int end, int startLine, int startColumn, int endLine, int endColumn, SourceInfo sourceInfo) {
        assert (start >= 0);
        assert (start <= end);
        this.start = start;
        this.end = end;
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
        this.sourceInfo = sourceInfo;
    }

    public boolean contains(Range o) {
        return this.start <= o.start && o.end <= this.end;
    }

    public Range createNormalizedCopy(int baseStart, int baseStartLine) {
        if (this.start < 0) {
            return new Range(baseStartLine, baseStartLine, baseStartLine, baseStartLine, baseStart, baseStartLine, this.sourceInfo);
        }
        return this.createOffsetCopy(-baseStart, -baseStartLine);
    }

    public Range createOffsetCopy(int positionOffset, int lineOffset) {
        return new Range(this.start + positionOffset, this.end + positionOffset, this.startLine + lineOffset, this.startColumn, this.endLine + lineOffset, this.endColumn, this.sourceInfo);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Range)) {
            return false;
        }
        Range o = (Range)obj;
        return this.start == o.start && this.end == o.end;
    }

    public int getEnd() {
        return this.end;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public int getStart() {
        return this.start;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int hashCode() {
        return 37 * this.start + this.end;
    }

    public int length() {
        return this.end - this.start;
    }

    public String toString() {
        return "[" + this.start + " - " + this.end + ")";
    }

    public Range withNewEnd(int newEnd, int newEndLine, int newEndColumn) {
        return new Range(this.start, newEnd, this.startLine, this.startColumn, newEndLine, newEndColumn, this.sourceInfo);
    }
}

