/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.linker.impl;

import com.google.gwt.core.ext.linker.StatementRanges;
import com.google.gwt.core.ext.linker.impl.StandardStatementRanges;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.ArrayList;

public class StatementRangesExtractor {
    private int lastRangeEndPosition;
    private int statementRangeIndex;
    private final StatementRanges statementRanges;

    public StatementRangesExtractor(StatementRanges statementRanges) {
        this.statementRanges = statementRanges;
    }

    public StatementRanges extract(int rangeStartPosition, int rangeEndPosition) {
        int statementEndPosition;
        int statementStartPosition;
        assert (this.statementRangeIndex < this.statementRanges.numStatements()) : "Ranges can't be extracted past the end.";
        this.skipTo(rangeStartPosition);
        this.lastRangeEndPosition = rangeEndPosition;
        ArrayList<Integer> statementStartPositions = Lists.newArrayList();
        ArrayList<Integer> statementEndPositions = Lists.newArrayList();
        while ((statementStartPosition = this.statementRanges.start(this.statementRangeIndex)) >= rangeStartPosition && statementStartPosition < rangeEndPosition && (statementEndPosition = this.statementRanges.end(this.statementRangeIndex)) > rangeStartPosition && statementEndPosition <= rangeEndPosition) {
            statementStartPositions.add(statementStartPosition);
            statementEndPositions.add(statementEndPosition);
            if (++this.statementRangeIndex < this.statementRanges.numStatements()) continue;
        }
        return new StandardStatementRanges(statementStartPositions, statementEndPositions);
    }

    private void skipTo(int rangeEndPosition) {
        int statementEndPosition;
        int statementStartPosition;
        assert (this.statementRangeIndex <= this.statementRanges.numStatements()) : "You can't skip past the end.";
        assert (this.lastRangeEndPosition <= rangeEndPosition) : "You can only skip forward.";
        while ((statementStartPosition = this.statementRanges.start(this.statementRangeIndex)) < rangeEndPosition && (statementEndPosition = this.statementRanges.end(this.statementRangeIndex)) <= rangeEndPosition && ++this.statementRangeIndex < this.statementRanges.numStatements()) {
        }
    }
}

