/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.linker.impl;

import com.google.gwt.core.ext.linker.StatementRanges;
import com.google.gwt.core.ext.linker.impl.StandardStatementRanges;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.LinkedList;

public class StatementRangesBuilder {
    private LinkedList<Integer> builderEndPositions = Lists.newLinkedList();
    private LinkedList<Integer> builderStartPositions = Lists.newLinkedList();

    public void addEndPosition(Integer endPosition) {
        this.builderEndPositions.add(endPosition);
    }

    public void addStartPosition(Integer startPosition) {
        this.builderStartPositions.add(startPosition);
    }

    public void append(StatementRanges newStatementRanges) {
        if (newStatementRanges.numStatements() == 0) {
            return;
        }
        int oldBaseOffset = newStatementRanges.start(0);
        int newBaseOffset = this.builderEndPositions.isEmpty() ? 0 : this.builderEndPositions.getLast();
        int baseOffsetDelta = newBaseOffset - oldBaseOffset;
        for (int i = 0; i < newStatementRanges.numStatements(); ++i) {
            this.builderStartPositions.add(newStatementRanges.start(i) + baseOffsetDelta);
            this.builderEndPositions.add(newStatementRanges.end(i) + baseOffsetDelta);
        }
    }

    public StatementRanges build() {
        return new StandardStatementRanges(this.builderStartPositions, this.builderEndPositions);
    }
}

