/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.linker.impl;

import com.google.gwt.core.ext.linker.SymbolData;
import java.io.File;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;

public class StandardSymbolData
implements SymbolData {
    private String className;
    private int fragmentNumber = -1;
    private String memberName;
    private String methodSig;
    private int sourceLine;
    private String sourceUri;
    private String symbolName;
    private String typeId;

    public static StandardSymbolData forClass(String className, String uriString, int lineNumber, String typeId) {
        return new StandardSymbolData(className, null, null, uriString, lineNumber, typeId);
    }

    public static StandardSymbolData forMember(String className, String memberName, String methodSig, String uriString, int lineNumber) {
        return new StandardSymbolData(className, memberName, methodSig, uriString, lineNumber, null);
    }

    public static String toUriString(String fileName) {
        File f = new File(fileName);
        if (f.exists()) {
            return f.toURI().toASCIIString();
        }
        try {
            return new URI(fileName).toASCIIString();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private StandardSymbolData(String className, String memberName, String methodSig, String sourceUri, int sourceLine, String typeId) {
        assert (className != null && className.length() > 0) : "className";
        assert (memberName != null || methodSig == null) : "methodSig without memberName";
        assert (sourceLine >= -1) : "sourceLine: " + sourceLine;
        this.className = className;
        this.memberName = memberName;
        this.methodSig = methodSig;
        this.sourceUri = sourceUri;
        this.sourceLine = sourceLine;
        this.typeId = typeId;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public int getFragmentNumber() {
        return this.fragmentNumber;
    }

    @Override
    public String getJsniIdent() {
        if (this.memberName == null) {
            return null;
        }
        if (this.methodSig == null) {
            return this.className + "::" + this.memberName;
        }
        return this.className + "::" + this.memberName + this.methodSig;
    }

    @Override
    public String getMemberName() {
        return this.memberName;
    }

    @Override
    public String getRuntimeTypeId() {
        return this.typeId;
    }

    @Override
    public int getSourceLine() {
        return this.sourceLine;
    }

    @Override
    public String getSourceUri() {
        return this.sourceUri;
    }

    @Override
    public String getSymbolName() {
        return this.symbolName;
    }

    @Override
    public boolean isClass() {
        return this.memberName == null;
    }

    @Override
    public boolean isField() {
        return this.memberName != null && this.methodSig == null;
    }

    @Override
    public boolean isMethod() {
        return this.methodSig != null;
    }

    public void setFragmentNumber(int fragNum) {
        this.fragmentNumber = fragNum;
    }

    public void setSymbolName(String symbolName) {
        this.symbolName = symbolName;
    }

    public String toString() {
        return this.isClass() ? this.className : this.getJsniIdent();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.className = (String)in.readObject();
        switch (in.read()) {
            case 0: {
                break;
            }
            case 1: {
                this.memberName = in.readUTF();
                break;
            }
            case 2: {
                this.memberName = in.readUTF();
                this.methodSig = in.readUTF();
                break;
            }
            default: {
                throw new InvalidObjectException("Unexpected input");
            }
        }
        this.sourceLine = in.readInt();
        this.sourceUri = (String)in.readObject();
        this.symbolName = in.readUTF();
        this.typeId = (String)in.readObject();
        this.fragmentNumber = in.readInt();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.className);
        if (this.isClass()) {
            out.write(0);
        } else if (this.isField()) {
            out.write(1);
            out.writeUTF(this.memberName);
        } else {
            out.write(2);
            out.writeUTF(this.memberName);
            out.writeUTF(this.methodSig);
        }
        out.writeInt(this.sourceLine);
        out.writeObject(this.sourceUri);
        out.writeUTF(this.symbolName);
        out.writeObject(this.typeId);
        out.writeInt(this.fragmentNumber);
    }
}

