/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.linker.impl;

import com.google.gwt.core.ext.linker.StatementRanges;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.primitives.Ints;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class StandardStatementRanges
implements StatementRanges,
Serializable {
    @VisibleForTesting
    final int[] ends;
    final int[] starts;

    public static StatementRanges combine(List<StatementRanges> statementRangesList) {
        ArrayList<Integer> combinedStarts = Lists.newArrayList();
        ArrayList<Integer> combinedEnds = Lists.newArrayList();
        int lastEndingOffset = 0;
        for (StatementRanges statementRanges : statementRangesList) {
            for (int i = 0; i < statementRanges.numStatements(); ++i) {
                combinedStarts.add(lastEndingOffset + statementRanges.start(i));
                combinedEnds.add(lastEndingOffset + statementRanges.end(i));
            }
            if (statementRanges.numStatements() <= 0) continue;
            lastEndingOffset += statementRanges.end(statementRanges.numStatements() - 1);
        }
        return new StandardStatementRanges(combinedStarts, combinedEnds);
    }

    public StandardStatementRanges(List<Integer> starts, List<Integer> ends) {
        assert (starts.size() == ends.size());
        this.starts = Ints.toArray(starts);
        this.ends = Ints.toArray(ends);
    }

    @Override
    public int end(int i) {
        return this.ends[i];
    }

    @Override
    public int numStatements() {
        return this.starts.length;
    }

    @Override
    public int start(int i) {
        return this.starts[i];
    }
}

