/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.linker.impl;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.ConfigurationProperty;
import com.google.gwt.core.ext.linker.PropertyProviderGenerator;
import com.google.gwt.core.ext.linker.SelectionProperty;
import com.google.gwt.dev.cfg.BindingProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

public class StandardSelectionProperty
implements SelectionProperty {
    private static final String FALLBACK_TOKEN = "/*-FALLBACK-*/";
    private final String activeValue;
    private final String fallback;
    private final boolean isDerived;
    private final String name;
    private final String provider;
    private final Class<? extends PropertyProviderGenerator> providerGenerator;
    private final SortedSet<String> values;

    public StandardSelectionProperty(BindingProperty p) {
        this.activeValue = p.getConstrainedValue();
        this.isDerived = p.isDerived();
        this.name = p.getName();
        this.fallback = p.getFallback();
        this.providerGenerator = p.getProviderGenerator();
        this.provider = p.getProvider() == null ? null : p.getProvider().getBody().replace(FALLBACK_TOKEN, this.fallback);
        this.values = Collections.unmodifiableSortedSet(new TreeSet<String>(Arrays.asList(p.getDefinedValues())));
    }

    @Override
    public String getFallbackValue() {
        return this.fallback;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SortedSet<String> getPossibleValues() {
        return this.values;
    }

    @Override
    public String getPropertyProvider(TreeLogger logger, SortedSet<ConfigurationProperty> configProperties) throws UnableToCompleteException {
        String generatorResult = null;
        if (this.providerGenerator != null) {
            ReflectiveOperationException caught = null;
            try {
                PropertyProviderGenerator gen = this.providerGenerator.newInstance();
                generatorResult = gen.generate(logger, this.values, this.fallback, configProperties);
            }
            catch (InstantiationException e) {
                caught = e;
            }
            catch (IllegalAccessException e) {
                caught = e;
            }
            if (caught != null) {
                logger.log(TreeLogger.WARN, "Failed to execute property provider generator '" + this.providerGenerator + "'", caught);
            }
        }
        return generatorResult != null ? generatorResult : this.provider;
    }

    @Override
    public boolean isDerived() {
        return this.isDerived;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getName()).append(" : [");
        for (String value : this.getPossibleValues()) {
            b.append(" ").append(value);
        }
        b.append(" ]");
        return b.toString();
    }

    @Override
    public String tryGetValue() {
        return this.activeValue;
    }
}

