/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.linker.impl;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.PublicResource;
import com.google.gwt.core.ext.linker.impl.StandardLinkerContext;
import com.google.gwt.dev.resource.Resource;
import com.google.gwt.dev.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class StandardPublicResource
extends PublicResource {
    private final Resource resource;

    public StandardPublicResource(String partialPath, Resource resource) {
        super(StandardLinkerContext.class, partialPath);
        this.resource = resource;
    }

    @Override
    public InputStream getContents(TreeLogger logger) throws UnableToCompleteException {
        try {
            return this.resource.openContents();
        }
        catch (IOException ex) {
            logger.log(TreeLogger.ERROR, "Problem reading resource: " + this.resource.getLocation(), ex);
            throw new UnableToCompleteException();
        }
    }

    @Override
    public long getLastModified() {
        return this.resource.getLastModified();
    }

    private Object writeReplace() {
        if (this.resource instanceof Serializable) {
            return this;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Util.copy(this.resource.openContents(), baos);
            return new SerializedPublicResource(this.getPartialPath(), baos.toByteArray(), this.getLastModified());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class SerializedPublicResource
    extends PublicResource {
        private final byte[] data;
        private final long lastModified;

        protected SerializedPublicResource(String partialPath, byte[] data, long lastModified) {
            super(StandardLinkerContext.class, partialPath);
            this.data = data;
            this.lastModified = lastModified;
        }

        @Override
        public InputStream getContents(TreeLogger logger) throws UnableToCompleteException {
            return new ByteArrayInputStream(this.data);
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }

        @Override
        public void writeTo(TreeLogger logger, OutputStream out) throws UnableToCompleteException {
            try {
                out.write(this.data);
            }
            catch (IOException e) {
                logger.log(TreeLogger.ERROR, "Unable to write to stream", e);
                throw new UnableToCompleteException();
            }
        }
    }
}

