/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.linker.impl;

import com.google.gwt.core.ext.Linker;
import com.google.gwt.core.ext.LinkerContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.ArtifactSet;
import com.google.gwt.core.ext.linker.ConfigurationProperty;
import com.google.gwt.core.ext.linker.EmittedArtifact;
import com.google.gwt.core.ext.linker.LinkerOrder;
import com.google.gwt.core.ext.linker.SelectionProperty;
import com.google.gwt.core.ext.linker.impl.StandardCompilationResult;
import com.google.gwt.core.ext.linker.impl.StandardConfigurationProperty;
import com.google.gwt.core.ext.linker.impl.StandardPublicResource;
import com.google.gwt.core.ext.linker.impl.StandardScriptReference;
import com.google.gwt.core.ext.linker.impl.StandardSelectionProperty;
import com.google.gwt.core.ext.linker.impl.StandardStylesheetReference;
import com.google.gwt.dev.cfg.BindingProperty;
import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.dev.cfg.Script;
import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.JsOutputOption;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.js.JsLiteralInterner;
import com.google.gwt.dev.js.JsNamer;
import com.google.gwt.dev.js.JsObfuscateNamer;
import com.google.gwt.dev.js.JsParser;
import com.google.gwt.dev.js.JsParserException;
import com.google.gwt.dev.js.JsPrettyNamer;
import com.google.gwt.dev.js.JsSourceGenerationVisitor;
import com.google.gwt.dev.js.JsSymbolResolver;
import com.google.gwt.dev.js.JsUnusedFunctionRemover;
import com.google.gwt.dev.js.JsVerboseNamer;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsModVisitor;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsScope;
import com.google.gwt.dev.resource.ResourceOracle;
import com.google.gwt.dev.util.DefaultTextOutput;
import com.google.gwt.dev.util.OutputFileSet;
import com.google.gwt.util.tools.Utility;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class StandardLinkerContext
extends Linker
implements LinkerContext {
    public static final Comparator<ConfigurationProperty> CONFIGURATION_PROPERTY_COMPARATOR = new Comparator<ConfigurationProperty>(){

        @Override
        public int compare(ConfigurationProperty o1, ConfigurationProperty o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    static final Comparator<SelectionProperty> SELECTION_PROPERTY_COMPARATOR = new Comparator<SelectionProperty>(){

        @Override
        public int compare(SelectionProperty o1, SelectionProperty o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private final SortedSet<ConfigurationProperty> configurationProperties;
    private final JsOutputOption outputOption;
    private final List<Class<? extends Linker>> linkerClasses;
    private Linker[] linkers;
    private final Map<Class<? extends Linker>, String> linkerShortNames = new HashMap<Class<? extends Linker>, String>();
    private final String moduleFunctionName;
    private final long moduleLastModified;
    private final String moduleName;
    private final Map<String, StandardSelectionProperty> propertiesByName = new HashMap<String, StandardSelectionProperty>();
    private ResourceOracle publicResourceOracle;
    private final SortedSet<SelectionProperty> selectionProperties;
    private final ModuleDef module;

    public StandardLinkerContext(TreeLogger logger, ModuleDef module, ResourceOracle publicResourceOracle, JsOutputOption outputOption) throws UnableToCompleteException {
        Object newProp;
        logger = logger.branch(TreeLogger.DEBUG, "Constructing StandardLinkerContext", null);
        this.moduleFunctionName = module.getFunctionName();
        this.moduleName = module.getName();
        this.moduleLastModified = module.lastModified();
        this.publicResourceOracle = publicResourceOracle;
        this.outputOption = outputOption;
        this.module = module;
        this.linkerClasses = new ArrayList<Class<? extends Linker>>();
        for (Class<? extends Linker> linkerClass : module.getActiveLinkers()) {
            LinkerOrder.Order order = linkerClass.getAnnotation(LinkerOrder.class).value();
            if (order == null) {
                logger.log(TreeLogger.Type.ERROR, linkerClass.getName() + " has no @LinkerOrder annotation");
                throw new UnableToCompleteException();
            }
            if (order != LinkerOrder.Order.PRE) continue;
            this.linkerClasses.add(linkerClass);
        }
        Class<? extends Linker> primary = module.getActivePrimaryLinker();
        if (primary == null) {
            logger.log(TreeLogger.ERROR, "Primary linker is null.  Does your module inherit from com.google.gwt.core.Core or com.google.gwt.user.User?");
        } else {
            this.linkerClasses.add(module.getActivePrimaryLinker());
        }
        ArrayList postLinkerClasses = new ArrayList();
        for (Class<? extends Linker> clazz : module.getActiveLinkers()) {
            LinkerOrder.Order order = clazz.getAnnotation(LinkerOrder.class).value();
            assert (order != null);
            if (order != LinkerOrder.Order.POST) continue;
            postLinkerClasses.add(clazz);
        }
        Collections.reverse(postLinkerClasses);
        this.linkerClasses.addAll(postLinkerClasses);
        this.resetLinkers(logger);
        for (Map.Entry entry : module.getLinkers().entrySet()) {
            this.linkerShortNames.put((Class)entry.getValue(), (String)entry.getKey());
        }
        this.linkerShortNames.put(this.getClass(), "");
        TreeSet<ConfigurationProperty> mutableConfigurationProperties = new TreeSet<ConfigurationProperty>(CONFIGURATION_PROPERTY_COMPARATOR);
        TreeSet<SelectionProperty> treeSet = new TreeSet<SelectionProperty>(SELECTION_PROPERTY_COMPARATOR);
        for (com.google.gwt.dev.cfg.ConfigurationProperty configurationProperty : module.getProperties().getConfigurationProperties()) {
            newProp = new StandardConfigurationProperty(configurationProperty);
            mutableConfigurationProperties.add((ConfigurationProperty)newProp);
            if (!logger.isLoggable(TreeLogger.SPAM)) continue;
            logger.log(TreeLogger.SPAM, "Added configuration property " + newProp, null);
        }
        for (BindingProperty bindingProperty : module.getProperties().getBindingProperties()) {
            newProp = new StandardSelectionProperty(bindingProperty);
            treeSet.add((SelectionProperty)newProp);
            this.propertiesByName.put(((StandardSelectionProperty)newProp).getName(), (StandardSelectionProperty)newProp);
            if (!logger.isLoggable(TreeLogger.SPAM)) continue;
            logger.log(TreeLogger.SPAM, "Added selection property " + newProp, null);
        }
        this.selectionProperties = Collections.unmodifiableSortedSet(treeSet);
        this.configurationProperties = Collections.unmodifiableSortedSet(mutableConfigurationProperties);
    }

    public boolean allLinkersAreShardable() {
        return this.findUnshardableLinkers().isEmpty();
    }

    public List<Linker> findUnshardableLinkers() {
        ArrayList<Linker> problemLinkers = new ArrayList<Linker>();
        for (Linker linker : this.linkers) {
            if (linker.isShardable()) continue;
            problemLinkers.add(linker);
        }
        return problemLinkers;
    }

    public ArtifactSet getArtifactsForPublicResources(TreeLogger logger, ModuleDef module) {
        ArtifactSet artifacts = new ArtifactSet();
        for (String path : this.publicResourceOracle.getPathNames()) {
            String partialPath = path.replace(File.separatorChar, '/');
            StandardPublicResource resource = new StandardPublicResource(partialPath, this.publicResourceOracle.getResource(path));
            artifacts.add(resource);
            if (!logger.isLoggable(TreeLogger.SPAM)) continue;
            logger.log(TreeLogger.SPAM, "Added public resource " + resource, null);
        }
        int index = 0;
        for (Script script : module.getScripts()) {
            String url = script.getSrc();
            artifacts.add(new StandardScriptReference(url, index++));
            if (!logger.isLoggable(TreeLogger.SPAM)) continue;
            logger.log(TreeLogger.SPAM, "Added script " + url, null);
        }
        index = 0;
        for (String style : module.getStyles()) {
            artifacts.add(new StandardStylesheetReference(style, index++));
            if (!logger.isLoggable(TreeLogger.SPAM)) continue;
            logger.log(TreeLogger.SPAM, "Added style " + style, null);
        }
        return artifacts;
    }

    @Override
    public SortedSet<ConfigurationProperty> getConfigurationProperties() {
        return this.configurationProperties;
    }

    @Override
    public String getDescription() {
        return "Root Linker";
    }

    public String getExtraPathForLinker(Class<? extends Linker> linkerType, String partialPath) {
        assert (this.linkerShortNames.containsKey(linkerType)) : linkerType.getName() + " unknown";
        return this.linkerShortNames.get(linkerType) + '/' + partialPath;
    }

    @Override
    public String getModuleFunctionName() {
        return this.moduleFunctionName;
    }

    @Override
    public long getModuleLastModified() {
        return this.moduleLastModified;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public SortedSet<SelectionProperty> getProperties() {
        return this.selectionProperties;
    }

    public StandardSelectionProperty getProperty(String name) {
        return this.propertiesByName.get(name);
    }

    public ArtifactSet invokeFinalLink(TreeLogger logger, ArtifactSet artifacts) throws UnableToCompleteException {
        for (Linker linker : this.linkers) {
            if (!linker.isShardable()) continue;
            TreeLogger linkerLogger = logger.branch(TreeLogger.TRACE, "Invoking Linker " + linker.getDescription(), null);
            artifacts = linker.link(linkerLogger, this, artifacts, false);
        }
        return artifacts;
    }

    public ArtifactSet invokeLegacyLinkers(TreeLogger logger, ArtifactSet artifacts) throws UnableToCompleteException {
        ArtifactSet workingArtifacts = new ArtifactSet(artifacts);
        for (Linker linker : this.linkers) {
            if (linker.isShardable()) continue;
            TreeLogger linkerLogger = logger.branch(TreeLogger.TRACE, "Invoking Linker " + linker.getDescription(), null);
            workingArtifacts.freeze();
            try {
                workingArtifacts = linker.link(linkerLogger, this, workingArtifacts);
            }
            catch (Throwable e) {
                linkerLogger.log(TreeLogger.ERROR, "Failed to link", e);
                throw new UnableToCompleteException();
            }
        }
        return workingArtifacts;
    }

    public ArtifactSet invokeLinkForOnePermutation(TreeLogger logger, StandardCompilationResult permResult, ArtifactSet permArtifacts) throws UnableToCompleteException {
        ArtifactSet workingArtifacts = new ArtifactSet(permArtifacts);
        workingArtifacts.add(permResult);
        for (Linker linker : this.linkers) {
            if (!linker.isShardable()) continue;
            TreeLogger linkerLogger = logger.branch(TreeLogger.TRACE, "Invoking Linker " + linker.getDescription(), null);
            try {
                workingArtifacts.freeze();
                workingArtifacts = linker.link(logger, this, workingArtifacts, true);
            }
            catch (Throwable e) {
                linkerLogger.log(TreeLogger.ERROR, "Failed to link", e);
                throw new UnableToCompleteException();
            }
        }
        this.resetLinkers(logger);
        workingArtifacts.freeze();
        return workingArtifacts;
    }

    public ArtifactSet invokeRelink(TreeLogger logger, ArtifactSet newlyGeneratedArtifacts) throws UnableToCompleteException {
        ArtifactSet workingArtifacts = new ArtifactSet(newlyGeneratedArtifacts);
        for (Linker linker : this.linkers) {
            TreeLogger linkerLogger = logger.branch(TreeLogger.TRACE, "Invoking relink on Linker " + linker.getDescription(), null);
            workingArtifacts.freeze();
            try {
                workingArtifacts = linker.relink(linkerLogger, this, workingArtifacts);
            }
            catch (Throwable e) {
                linkerLogger.log(TreeLogger.ERROR, "Failed to relink", e);
                throw new UnableToCompleteException();
            }
        }
        return workingArtifacts;
    }

    @Override
    public boolean isOutputCompact() {
        return this.outputOption.shouldMinimize();
    }

    @Override
    public ArtifactSet link(TreeLogger logger, LinkerContext context, ArtifactSet artifacts) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String optimizeJavaScript(TreeLogger logger, String program) throws UnableToCompleteException {
        logger = logger.branch(TreeLogger.DEBUG, "Attempting to optimize JS", null);
        StringReader r = new StringReader(program);
        JsProgram jsProgram = new JsProgram();
        JsScope topScope = jsProgram.getScope();
        topScope.declareUnobfuscatableName(this.getModuleFunctionName());
        try {
            SourceInfo sourceInfo = jsProgram.createSourceInfo(1, "StandardLinkerContext.optimizeJavaScript");
            JsParser.parseInto(sourceInfo, topScope, jsProgram.getGlobalBlock(), r);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error reading in-memory stream", e);
        }
        catch (JsParserException e) {
            logger.log(TreeLogger.ERROR, "Unable to parse JavaScript", e);
            throw new UnableToCompleteException();
        }
        JsSymbolResolver.exec(jsProgram);
        JsUnusedFunctionRemover.exec(jsProgram);
        try {
            switch (this.outputOption) {
                case OBFUSCATED: {
                    TopFunctionStringInterner.exec(jsProgram);
                    JsObfuscateNamer.exec(jsProgram, null);
                    break;
                }
                case PRETTY: {
                    JsPrettyNamer.exec(jsProgram, null);
                    break;
                }
                case DETAILED: {
                    TopFunctionStringInterner.exec(jsProgram);
                    JsVerboseNamer.exec(jsProgram, null);
                    break;
                }
                default: {
                    throw new InternalCompilerException("Unknown output mode");
                }
            }
        }
        catch (JsNamer.IllegalNameException e) {
            logger.log(TreeLogger.ERROR, e.getMessage(), e);
            throw new UnableToCompleteException();
        }
        DefaultTextOutput out = new DefaultTextOutput(this.outputOption.shouldMinimize());
        JsSourceGenerationVisitor v = new JsSourceGenerationVisitor(out);
        v.accept(jsProgram);
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceOutput(TreeLogger logger, ArtifactSet artifacts, EmittedArtifact.Visibility visibility, OutputFileSet out) throws UnableToCompleteException {
        logger = logger.branch(TreeLogger.TRACE, "Linking " + (Object)((Object)visibility) + " artifacts into " + out.getPathDescription(), null);
        for (EmittedArtifact artifact : artifacts.find(EmittedArtifact.class)) {
            TreeLogger artifactLogger = logger.branch(TreeLogger.DEBUG, "Emitting resource " + artifact.getPartialPath(), null);
            if (!artifact.getVisibility().matches(visibility)) continue;
            String partialPath = artifact.getPartialPath();
            if (artifact.getVisibility() != EmittedArtifact.Visibility.Public && (partialPath = this.getExtraPathForLinker(artifact.getLinker(), partialPath)).startsWith("/")) {
                partialPath = partialPath.substring(1);
            }
            BufferedOutputStream artifactStream = null;
            try {
                artifactStream = new BufferedOutputStream(out.openForWrite(partialPath, artifact.getLastModified()));
                artifact.writeTo(artifactLogger, artifactStream);
            }
            catch (IOException e) {
                block6: {
                    try {
                        artifactLogger.log(TreeLogger.ERROR, "Fatal error emitting artifact: " + artifact.getPartialPath(), e);
                        if (visibility == EmittedArtifact.Visibility.Private) break block6;
                        throw new UnableToCompleteException();
                    }
                    catch (Throwable throwable) {
                        Utility.close(artifactStream);
                        throw throwable;
                    }
                }
                Utility.close(artifactStream);
                continue;
            }
            Utility.close(artifactStream);
        }
    }

    public ModuleDef getModule() {
        return this.module;
    }

    private void resetLinkers(TreeLogger logger) throws UnableToCompleteException {
        this.linkers = new Linker[this.linkerClasses.size()];
        int i = 0;
        for (Class<? extends Linker> linkerClass : this.linkerClasses) {
            try {
                this.linkers[i++] = linkerClass.newInstance();
            }
            catch (InstantiationException e) {
                logger.log(TreeLogger.ERROR, "Unable to create Linker", e);
                throw new UnableToCompleteException();
            }
            catch (IllegalAccessException e) {
                logger.log(TreeLogger.ERROR, "Unable to create Linker", e);
                throw new UnableToCompleteException();
            }
        }
    }

    private static class TopFunctionStringInterner
    extends JsModVisitor {
        private final JsProgram program;

        public static boolean exec(JsProgram program) {
            TopFunctionStringInterner v = new TopFunctionStringInterner(program);
            v.accept(program);
            return v.didChange();
        }

        public TopFunctionStringInterner(JsProgram program) {
            this.program = program;
        }

        @Override
        public boolean visit(JsFunction x, JsContext ctx) {
            this.didChange |= JsLiteralInterner.exec(this.program, x.getBody(), x.getScope(), true);
            return false;
        }
    }
}

