/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.linker.impl;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.GeneratedResource;
import com.google.gwt.core.ext.linker.impl.StandardLinkerContext;
import com.google.gwt.dev.util.DiskCache;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class StandardGeneratedResource
extends GeneratedResource {
    private static final DiskCache diskCache = DiskCache.INSTANCE;
    private final long lastModified = System.currentTimeMillis();
    private transient long token;

    public StandardGeneratedResource(String partialPath, byte[] data) {
        super(StandardLinkerContext.class, partialPath);
        this.token = diskCache.writeByteArray(data);
    }

    public StandardGeneratedResource(String partialPath, long token) {
        super(StandardLinkerContext.class, partialPath);
        this.token = token;
    }

    @Override
    public InputStream getContents(TreeLogger logger) throws UnableToCompleteException {
        return new ByteArrayInputStream(diskCache.readByteArray(this.token));
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public void writeTo(TreeLogger logger, OutputStream out) throws UnableToCompleteException {
        try {
            diskCache.transferToStream(this.token, out);
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "Unable to copy artifact: " + this.getPartialPath(), e);
            throw new UnableToCompleteException();
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.token = diskCache.transferFromStream(stream);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        diskCache.transferToStream(this.token, stream);
    }
}

