/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.linker.impl;

import com.google.gwt.core.ext.soyc.Range;
import com.google.gwt.dev.jjs.JsSourceMap;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class JsSourceMapExtractor {
    private int lastTypeEndPosition;
    private LinkedList<Range> ranges = Lists.newLinkedList();

    public JsSourceMapExtractor(List<Range> ranges) {
        this.ranges.addAll(ranges);
    }

    public JsSourceMap extract(int typeStartPosition, int typeEndPosition, int typeStartLineNumber, int typeEndLineNumber) {
        Range range;
        assert (!this.ranges.isEmpty()) : "Source mappings can't be extracted past the end.";
        this.skipTo(typeStartPosition);
        this.lastTypeEndPosition = typeEndPosition;
        ArrayList<Range> extractedRanges = Lists.newArrayList();
        while (!this.ranges.isEmpty() && (range = this.ranges.getFirst()).getStart() >= typeStartPosition && range.getStart() < typeEndPosition && range.getEnd() > typeStartPosition && range.getEnd() <= typeEndPosition) {
            this.ranges.removeFirst();
            Range typeOffsetNormalizedRange = range.createNormalizedCopy(typeStartPosition, typeStartLineNumber);
            extractedRanges.add(typeOffsetNormalizedRange);
        }
        int typeBytes = typeEndPosition - typeStartPosition;
        int typeLines = typeEndLineNumber - typeStartLineNumber;
        return new JsSourceMap(extractedRanges, typeBytes, typeLines);
    }

    private void skipTo(int rangeEndPosition) {
        Range range;
        assert (this.lastTypeEndPosition <= rangeEndPosition) : "You can only skip forward.";
        while (!this.ranges.isEmpty() && (range = this.ranges.getFirst()).getStart() < rangeEndPosition && range.getEnd() <= rangeEndPosition) {
            this.ranges.removeFirst();
        }
    }
}

