/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.linker.impl;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.BinaryEmittedArtifact;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarEntryEmittedArtifact
extends BinaryEmittedArtifact {
    private final JarEntry entry;
    private final File file;

    public JarEntryEmittedArtifact(String path, File jarFile, JarEntry entry) {
        super(path);
        this.file = jarFile;
        this.entry = entry;
    }

    @Override
    public InputStream getContents(TreeLogger logger) throws UnableToCompleteException {
        try {
            return new JarEntryInputStream();
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "unexpected IOException", e);
            throw new UnableToCompleteException();
        }
    }

    @Override
    public long getLastModified() {
        return this.entry.getTime();
    }

    private class JarEntryInputStream
    extends InputStream {
        private JarFile jarFile;
        private InputStream stream;

        public JarEntryInputStream() throws IOException {
            this.jarFile = new JarFile(JarEntryEmittedArtifact.this.file);
            this.stream = this.jarFile.getInputStream(JarEntryEmittedArtifact.this.entry);
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
            this.jarFile.close();
        }

        @Override
        public int read() throws IOException {
            return this.stream.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.stream.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.stream.read(b, off, len);
        }
    }
}

