/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.linker;

import com.google.gwt.thirdparty.guava.common.base.Supplier;
import com.google.gwt.thirdparty.guava.common.collect.ForwardingIterator;
import com.google.gwt.thirdparty.guava.common.collect.ForwardingSortedSet;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSortedSet;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;
import com.google.gwt.thirdparty.guava.common.collect.Multimaps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

class TypeIndexedSet<T extends Comparable>
extends ForwardingSortedSet<T>
implements Serializable {
    private SortedSet<T> treeSet;
    private transient TypeIndex byType;

    protected TypeIndexedSet(SortedSet<T> backing) {
        this(backing, new TypeIndex(backing));
    }

    private TypeIndexedSet(SortedSet<T> backing, TypeIndex byType) {
        this.treeSet = backing;
        this.byType = byType;
    }

    @Override
    protected SortedSet<T> delegate() {
        return this.treeSet;
    }

    TypeIndex getTypeIndex() {
        return this.byType;
    }

    private SortedSet<T> createView(final SortedSet<T> rawView) {
        return new ForwardingSortedSet<T>(){
            private final TypeIndexedSet<T> wrappedForIndexMutates;
            {
                this.wrappedForIndexMutates = new TypeIndexedSet(rawView, TypeIndexedSet.this.byType);
            }

            @Override
            protected SortedSet<T> delegate() {
                return this.wrappedForIndexMutates;
            }
        };
    }

    @Override
    public boolean add(T o) {
        if (super.add(o)) {
            this.byType.add((Comparable)o);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean somethingChanged = false;
        for (Comparable a : c) {
            somethingChanged |= this.add((T)a);
        }
        return somethingChanged;
    }

    @Override
    public void clear() {
        super.clear();
        this.byType.clear();
    }

    public void freeze() {
        if (this.treeSet instanceof TreeSet) {
            this.treeSet = Collections.unmodifiableSortedSet(this.treeSet);
        }
    }

    @Override
    public SortedSet<T> headSet(T toElement) {
        return this.createView(super.headSet(toElement));
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator backing = super.iterator();
        return new ForwardingIterator<T>(){
            private T previous;

            @Override
            protected Iterator<T> delegate() {
                return backing;
            }

            @Override
            public T next() {
                this.previous = (Comparable)this.delegate().next();
                return this.previous;
            }

            @Override
            public void remove() {
                this.delegate().remove();
                TypeIndexedSet.this.byType.remove(this.previous);
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        if (super.remove(o)) {
            this.byType.remove(o);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean somethingChanged = false;
        for (Object o : c) {
            somethingChanged |= this.remove(o);
        }
        return somethingChanged;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (super.retainAll(c)) {
            this.byType.clear();
            return true;
        }
        return false;
    }

    @Override
    public SortedSet<T> subSet(T fromElement, T toElement) {
        return this.createView(super.subSet(fromElement, toElement));
    }

    @Override
    public SortedSet<T> tailSet(T fromElement) {
        return this.createView(super.tailSet(fromElement));
    }

    static final class TypeIndex {
        private static final Supplier<SortedSet<Comparable>> TREE_SETS = new Supplier<SortedSet<Comparable>>(){

            @Override
            public SortedSet<Comparable> get() {
                return new TreeSet<Comparable>();
            }
        };
        private final Iterable<? extends Comparable> elements;
        private transient Multimap<Class<?>, Comparable> index = null;
        private transient Map<Class<?>, SortedSet<?>> findCache;

        TypeIndex(Iterable<? extends Comparable> elements) {
            this.elements = elements;
        }

        void clear() {
            this.findCache = null;
            this.index = null;
        }

        void add(Comparable o) {
            if (this.index != null) {
                this.index.put(o.getClass(), o);
            }
            this.findCache = null;
        }

        void remove(Object o) {
            if (this.index != null) {
                this.index.remove(o.getClass(), o);
            }
            this.findCache = null;
        }

        <T extends Comparable> SortedSet<T> findAssignableTo(Class<T> type) {
            if (this.findCache == null) {
                this.findCache = new HashMap();
            } else {
                SortedSet<?> s = this.findCache.get(type);
                if (s != null) {
                    return s;
                }
            }
            if (this.index == null) {
                this.generateTypeIndex();
            }
            ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
            for (Map.Entry<Class<?>, Collection<Comparable>> entry : this.index.asMap().entrySet()) {
                if (!type.isAssignableFrom(entry.getKey())) continue;
                builder.addAll((Iterable)((SortedSet)entry.getValue()));
            }
            ImmutableSet toReturn = builder.build();
            this.findCache.put(type, (SortedSet<?>)((Object)toReturn));
            return toReturn;
        }

        private void generateTypeIndex() {
            this.index = Multimaps.newSortedSetMultimap(new HashMap(), TREE_SETS);
            for (Comparable comparable : this.elements) {
                this.index.put(comparable.getClass(), comparable);
            }
        }
    }
}

