/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.linker;

import com.google.gwt.core.ext.Linker;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.EmittedArtifact;
import com.google.gwt.dev.util.DiskCache;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class SyntheticArtifact
extends EmittedArtifact {
    private static final DiskCache diskCache = DiskCache.INSTANCE;
    private final long lastModified;
    private transient long token;

    public SyntheticArtifact(Class<? extends Linker> linkerType, String partialPath, byte[] data) {
        this(linkerType, partialPath, data, System.currentTimeMillis());
    }

    public SyntheticArtifact(Class<? extends Linker> linkerType, String partialPath, byte[] data, long lastModified) {
        super(linkerType, partialPath);
        assert (data != null);
        this.lastModified = lastModified;
        this.token = diskCache.writeByteArray(data);
    }

    @Override
    public InputStream getContents(TreeLogger logger) throws UnableToCompleteException {
        return new ByteArrayInputStream(diskCache.readByteArray(this.token));
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public void writeTo(TreeLogger logger, OutputStream out) throws UnableToCompleteException {
        try {
            diskCache.transferToStream(this.token, out);
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "Unable to copy artifact: " + this.getPartialPath(), e);
            throw new UnableToCompleteException();
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.token = diskCache.transferFromStream(stream);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        diskCache.transferToStream(this.token, stream);
    }
}

