/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.linker;

import java.io.Serializable;
import java.util.Comparator;

public interface SymbolData
extends Serializable {
    public String getClassName();

    public int getFragmentNumber();

    public String getJsniIdent();

    public String getMemberName();

    public String getRuntimeTypeId();

    public int getSourceLine();

    public String getSourceUri();

    public String getSymbolName();

    public boolean isClass();

    public boolean isField();

    public boolean isMethod();

    public static class ClassIdentComparator
    implements Comparator<SymbolData>,
    Serializable {
        @Override
        public int compare(SymbolData o1, SymbolData o2) {
            if (o1 == o2) {
                return 0;
            }
            int result = o1.getClassName().compareTo(o2.getClassName());
            if (result != 0) {
                return result;
            }
            if (o1.isClass()) {
                if (o2.isClass()) {
                    return 0;
                }
                return -1;
            }
            if (o2.isClass()) {
                return 1;
            }
            result = o1.getMemberName().compareTo(o2.getMemberName());
            if (result != 0) {
                return result;
            }
            if (o1.isField()) {
                if (o2.isField()) {
                    return 0;
                }
                return -1;
            }
            if (o2.isField()) {
                return 1;
            }
            return o1.getJsniIdent().compareTo(o2.getJsniIdent());
        }
    }
}

