/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.linker;

import com.google.gwt.core.ext.Linker;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.Artifact;
import com.google.gwt.dev.util.Util;
import com.google.gwt.util.tools.Utility;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class EmittedArtifact
extends Artifact<EmittedArtifact> {
    private final String partialPath;
    private Visibility visibility;

    protected EmittedArtifact(Class<? extends Linker> linker, String partialPath) {
        super(linker);
        assert (partialPath != null);
        this.partialPath = partialPath;
        this.visibility = Visibility.Public;
    }

    public abstract InputStream getContents(TreeLogger var1) throws UnableToCompleteException;

    public long getLastModified() {
        return System.currentTimeMillis();
    }

    public final String getPartialPath() {
        return this.partialPath;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public final int hashCode() {
        return this.getPartialPath().hashCode();
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @Override
    public String toString() {
        return this.getPartialPath();
    }

    public void writeTo(TreeLogger logger, OutputStream out) throws UnableToCompleteException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(this.getContents(logger));
            Util.copyNoClose(in, out);
        }
        catch (IOException e) {
            try {
                logger.log(TreeLogger.ERROR, "Unable to copy artifact: " + this.getPartialPath(), e);
                throw new UnableToCompleteException();
            }
            catch (Throwable throwable) {
                Utility.close(in);
                throw throwable;
            }
        }
        Utility.close(in);
    }

    @Override
    protected final int compareToComparableArtifact(EmittedArtifact o) {
        return this.getPartialPath().compareTo(o.getPartialPath());
    }

    @Override
    protected final Class<EmittedArtifact> getComparableArtifactType() {
        return EmittedArtifact.class;
    }

    public static enum Visibility {
        Public,
        Private{

            @Override
            public boolean matches(Visibility visibility) {
                switch (visibility) {
                    case LegacyDeploy: 
                    case Private: {
                        return true;
                    }
                }
                return false;
            }
        }
        ,
        Deploy{

            @Override
            public boolean matches(Visibility visibility) {
                switch (visibility) {
                    case LegacyDeploy: 
                    case Deploy: {
                        return true;
                    }
                }
                return false;
            }
        }
        ,
        Source,
        LegacyDeploy{

            @Override
            public boolean matches(Visibility visibility) {
                switch (visibility) {
                    case LegacyDeploy: 
                    case Private: 
                    case Deploy: {
                        return true;
                    }
                }
                return false;
            }
        };


        public boolean matches(Visibility visibility) {
            return this == visibility;
        }
    }
}

