/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.linker;

import com.google.gwt.core.ext.Linker;
import com.google.gwt.core.ext.linker.Transferable;
import java.io.Serializable;

public abstract class Artifact<C extends Artifact<C>>
implements Comparable<Artifact<?>>,
Serializable {
    private transient Class<? extends Linker> linker;
    private final String linkerName;

    protected Artifact(Class<? extends Linker> linker) {
        assert (linker != null);
        this.linkerName = linker.getName();
        this.linker = linker;
    }

    @Override
    public final int compareTo(Artifact<?> o) {
        if (this.getComparableArtifactType().equals(o.getComparableArtifactType())) {
            return this.compareToComparableArtifact((Artifact)this.getComparableArtifactType().cast(o));
        }
        return this.getComparableArtifactType().getName().compareTo(o.getComparableArtifactType().getName());
    }

    public final boolean equals(Object obj) {
        if (obj instanceof Artifact) {
            return this.compareTo((Artifact)obj) == 0;
        }
        return false;
    }

    public final Class<? extends Linker> getLinker() {
        if (this.linker == null) {
            try {
                Class<?> clazz = Class.forName(this.linkerName, false, Thread.currentThread().getContextClassLoader());
                this.linker = clazz.asSubclass(Linker.class);
            }
            catch (ClassNotFoundException e) {
                this.linker = Linker.class;
            }
        }
        return this.linker;
    }

    public abstract int hashCode();

    public final boolean isTransferableFromShards() {
        return this.getClass().isAnnotationPresent(Transferable.class);
    }

    public String toString() {
        return this.getClass().getName() + " created by " + this.getLinker().getName();
    }

    protected abstract int compareToComparableArtifact(C var1);

    protected abstract Class<C> getComparableArtifactType();
}

