/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext.impl;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.resource.Resource;
import com.google.gwt.dev.resource.ResourceOracle;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ResourceLocatorImpl {
    private static final int CLASS_LOADER_LOAD_REPORT_LIMIT = 10;
    private static int classLoaderLoadCount;

    public static void resetClassLoaderLoadWarningCount() {
        classLoaderLoadCount = 0;
    }

    public static InputStream tryFindResourceAsStream(TreeLogger logger, ResourceOracle resourceOracle, String resourceName) {
        URL url = ResourceLocatorImpl.tryFindResourceUrl(logger, resourceOracle, resourceName);
        if (url == null) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static URL tryFindResourceUrl(TreeLogger logger, ResourceOracle resourceOracle, String resourceName) {
        Resource resource = resourceOracle.getResource(resourceName);
        if (resource != null) {
            return resource.getURL();
        }
        URL resourceUrl = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (resourceUrl != null) {
            if (classLoaderLoadCount++ < 10) {
                logger.log(TreeLogger.WARN, "Resource '" + resourceName + "' was located via ClassLoader. As a result changes in that resource will not be reflected in per-file recompiles. It should be registered via  <source /> or <resource /> entry in your .gwt.xml. In a future version of GWT, we will remove this fallback and your application will stop compiling");
                if (classLoaderLoadCount == 10) {
                    logger.log(TreeLogger.WARN, "Suppressing further ClassLoader resource load warnings.");
                }
            }
            return resourceUrl;
        }
        return null;
    }
}

