/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext;

import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.ConfigurationProperty;
import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.SelectionProperty;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.cfg.RuleGenerateWith;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import java.util.Set;

public class SubsetFilteringPropertyOracle
implements PropertyOracle {
    private final Set<String> accessiblePropertyNames;
    private final String accessViolationMessage;
    private final PropertyOracle wrappedPropertyOracle;

    public SubsetFilteringPropertyOracle(Set<String> accessiblePropertyNames, PropertyOracle wrappedPropertyOracle, String accessViolationMessage) {
        this.accessiblePropertyNames = accessiblePropertyNames;
        this.wrappedPropertyOracle = wrappedPropertyOracle;
        this.accessViolationMessage = accessViolationMessage;
    }

    @Override
    public ConfigurationProperty getConfigurationProperty(String propertyName) throws BadPropertyValueException {
        Preconditions.checkState(this.accessiblePropertyNames.equals(RuleGenerateWith.ALL_PROPERTIES) || this.accessiblePropertyNames.contains(propertyName), "Access to configuration property '" + propertyName + "' is not allowed. " + this.accessViolationMessage);
        return this.wrappedPropertyOracle.getConfigurationProperty(propertyName);
    }

    @Override
    public SelectionProperty getSelectionProperty(TreeLogger logger, String propertyName) throws BadPropertyValueException {
        Preconditions.checkState(this.accessiblePropertyNames.equals(RuleGenerateWith.ALL_PROPERTIES) || this.accessiblePropertyNames.contains(propertyName), "Access to binding property '" + propertyName + "' is not allowed. " + this.accessViolationMessage);
        return this.wrappedPropertyOracle.getSelectionProperty(logger, propertyName);
    }
}

