/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext;

import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.NonIncrementalGeneratorContext;
import com.google.gwt.core.ext.RebindMode;
import com.google.gwt.core.ext.RebindResult;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;

public abstract class IncrementalGenerator
extends Generator {
    public static RebindResult generateNonIncrementally(TreeLogger logger, Generator generator, GeneratorContext context, String typeName) throws UnableToCompleteException {
        RebindMode mode;
        String resultTypeName = generator.generate(logger, context, typeName);
        if (resultTypeName == null) {
            mode = RebindMode.USE_EXISTING;
            resultTypeName = typeName;
        } else {
            mode = RebindMode.USE_ALL_NEW_WITH_NO_CACHING;
        }
        return new RebindResult(mode, resultTypeName);
    }

    @Override
    public final String generate(TreeLogger logger, GeneratorContext context, String typeName) throws UnableToCompleteException {
        GeneratorContext wrappedContext = NonIncrementalGeneratorContext.newInstance(context);
        RebindResult result = this.generateIncrementally(logger, wrappedContext, typeName);
        return result.getResultTypeName();
    }

    public abstract RebindResult generateIncrementally(TreeLogger var1, GeneratorContext var2, String var3) throws UnableToCompleteException;

    public abstract long getVersionId();
}

