/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext;

import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.thirdparty.guava.common.base.Strings;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class Generator {
    private static final int MAX_SIXTEEN_BIT_NUMBER_STRING_LENGTH = 5;

    public static String escape(String unescaped) {
        int extra = 0;
        int n = unescaped.length();
        for (int in = 0; in < n; ++in) {
            switch (unescaped.charAt(in)) {
                case '\u0000': 
                case '\n': 
                case '\r': 
                case '\"': 
                case '\\': {
                    ++extra;
                }
            }
        }
        if (extra == 0) {
            return unescaped;
        }
        char[] oldChars = unescaped.toCharArray();
        char[] newChars = new char[oldChars.length + extra];
        int in = 0;
        int out = 0;
        int n2 = oldChars.length;
        while (in < n2) {
            int c = oldChars[in];
            switch (c) {
                case 0: {
                    newChars[out++] = 92;
                    c = 48;
                    break;
                }
                case 10: {
                    newChars[out++] = 92;
                    c = 110;
                    break;
                }
                case 13: {
                    newChars[out++] = 92;
                    c = 114;
                    break;
                }
                case 34: {
                    newChars[out++] = 92;
                    c = 34;
                    break;
                }
                case 92: {
                    newChars[out++] = 92;
                    c = 92;
                }
            }
            newChars[out] = c;
            ++in;
            ++out;
        }
        return String.valueOf(newChars);
    }

    public static String escapeClassName(String unescapedString) {
        char[] unescapedCharacters = unescapedString.toCharArray();
        StringBuilder escapedCharacters = new StringBuilder();
        boolean firstCharacter = true;
        for (char unescapedCharacter : unescapedCharacters) {
            if (firstCharacter && !Character.isJavaIdentifierStart(unescapedCharacter)) {
                Generator.escapeAndAppendCharacter(escapedCharacters, unescapedCharacter);
            } else if (!Character.isJavaIdentifierPart(unescapedCharacter)) {
                Generator.escapeAndAppendCharacter(escapedCharacters, unescapedCharacter);
            } else if (unescapedCharacter == '_') {
                escapedCharacters.append("__");
            } else {
                escapedCharacters.append(unescapedCharacter);
            }
            firstCharacter = false;
        }
        return escapedCharacters.toString();
    }

    private static void escapeAndAppendCharacter(StringBuilder escapedCharacters, char unescapedCharacter) {
        String numberString = Integer.toString(unescapedCharacter);
        numberString = Strings.padStart(numberString, 5, '0');
        escapedCharacters.append("_" + numberString);
    }

    public abstract String generate(TreeLogger var1, GeneratorContext var2, String var3) throws UnableToCompleteException;

    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RunsLocal {
        public static final String ALL = "%ALL%";

        public String[] requiresProperties() default {};
    }
}

