/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.ext;

import com.google.gwt.core.ext.SelectionProperty;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;

public class DefaultSelectionProperty
implements SelectionProperty {
    private final String currentValue;
    private final String fallbackValue;
    private final String name;
    private final SortedSet<String> possibleValues;
    private final Map<String, ? extends List<? extends Set<String>>> fallbackValueMap;

    public DefaultSelectionProperty(String currentValue, String fallbackValue, String name, SortedSet<String> possibleValues) {
        this(currentValue, fallbackValue, name, possibleValues, null);
    }

    public DefaultSelectionProperty(String currentValue, String fallbackValue, String name, SortedSet<String> possibleValues, Map<String, ? extends List<? extends Set<String>>> fallbackValueMap) {
        assert (currentValue != null);
        assert (fallbackValue != null);
        assert (name != null);
        assert (possibleValues != null);
        this.currentValue = currentValue;
        this.fallbackValue = fallbackValue;
        this.name = name;
        this.possibleValues = possibleValues;
        this.fallbackValueMap = fallbackValueMap;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultSelectionProperty other = (DefaultSelectionProperty)obj;
        return this.currentValue.equals(other.currentValue) && this.fallbackValue.equals(other.fallbackValue) && this.name.equals(other.name) && this.possibleValues.equals(other.possibleValues);
    }

    @Override
    public String getCurrentValue() {
        return this.currentValue;
    }

    @Override
    public String getFallbackValue() {
        return this.fallbackValue;
    }

    @Override
    public List<? extends Set<String>> getFallbackValues(String value) {
        return null != this.fallbackValueMap ? this.fallbackValueMap.get(value) : null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SortedSet<String> getPossibleValues() {
        return this.possibleValues;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.currentValue.hashCode();
        result = 31 * result + this.fallbackValue.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.possibleValues.hashCode();
        return result;
    }

    public String toString() {
        return "SelectionProp " + this.name + ": " + this.currentValue + " of " + this.possibleValues.toString() + ", fallback =" + this.fallbackValue;
    }
}

